/*
 * Decompiled with CFR 0.152.
 */
package io.continual.resources.sources;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import io.continual.resources.ResourceLoader;
import io.continual.resources.ResourceSource;
import io.continual.util.data.StreamTools;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AwsS3BucketAndKeyLoader
implements ResourceSource {
    private final AWSCredentials fCreds;
    private final String fBucket;
    private AmazonS3 fClient = null;
    private static final Logger log = LoggerFactory.getLogger(ResourceLoader.class);

    public AwsS3BucketAndKeyLoader(String bucket) {
        this.fBucket = bucket;
        this.fCreds = new AWSCredentials(){

            public String getAWSAccessKeyId() {
                return System.getenv("AWS_ACCESS_KEY_ID");
            }

            public String getAWSSecretKey() {
                return System.getenv("AWS_SECRET_ACCESS_KEY");
            }
        };
    }

    @Override
    public boolean qualifies(String resourceId) {
        return true;
    }

    @Override
    public InputStream loadResource(String resourceId) throws IOException {
        try {
            if (this.fClient == null) {
                this.fClient = (AmazonS3)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider(this.fCreds))).build();
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (S3Object object = null;){
                object = this.fClient.getObject(new GetObjectRequest(this.fBucket, resourceId));
                S3ObjectInputStream is = object.getObjectContent();
                StreamTools.copyStream((InputStream)is, (OutputStream)baos);
            }
            return new ByteArrayInputStream(baos.toByteArray());
        }
        catch (NoClassDefFoundError x) {
            log.warn("URL [" + resourceId + "] requires the AWS S3 libraries but they're not available. " + x.getMessage(), (Throwable)x);
            throw new IOException(x);
        }
    }
}

