/*
 * Decompiled with CFR 0.152.
 */
package io.continual.http.service.framework.routing.playish;

import io.continual.http.service.framework.context.CHttpRequestContext;
import io.continual.http.service.framework.routing.playish.CHttpPlayishRouteHandler;
import io.continual.http.service.framework.routing.playish.StaticDirHandler;
import io.continual.resources.ResourceLoader;
import io.continual.util.data.StreamTools;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticFileHandler
implements CHttpPlayishRouteHandler {
    public static final String kSetting_CacheMaxAge = "chttp.staticFile.cache.maxAgeSeconds";
    public static final int kDefault_CacheMaxAge = -1;
    private final String fFile;
    private final String fContentType;
    private final int fCacheMaxAge;
    private static final Logger log = LoggerFactory.getLogger(StaticFileHandler.class);

    public StaticFileHandler(String routedPath, String staticFile) {
        this(routedPath, staticFile, -1);
    }

    public StaticFileHandler(String routedPath, String staticFile, int cacheMaxAge) {
        String file = staticFile.endsWith("/") ? staticFile + routedPath : staticFile;
        this.fFile = file = file.replaceAll("//", "/");
        this.fContentType = StaticDirHandler.mapToContentType(this.fFile);
        this.fCacheMaxAge = cacheMaxAge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(CHttpRequestContext context, List<String> args) throws IOException {
        if (this.fCacheMaxAge > 0) {
            context.response().writeHeader("Cache-Control", "max-age=" + this.fCacheMaxAge, true);
        }
        log.info("finding stream [" + this.fFile + "]");
        InputStream is = new ResourceLoader().usingStandardSources(true, this.getClass()).named(this.fFile).load();
        if (is == null) {
            log.warn("404 [" + this.fFile + "] not found");
            context.response().sendError(404, this.fFile + " was not found on this server.");
        } else {
            try {
                StreamTools.copyStream((InputStream)is, (OutputStream)context.response().getStreamForBinaryResponse(this.fContentType));
            }
            finally {
                is.close();
            }
        }
    }

    @Override
    public boolean actionMatches(String fullPath) {
        return false;
    }
}

