/*
 * Decompiled with CFR 0.152.
 */
package io.continual.iam.impl.common.jwt;

import io.continual.builder.Builder;
import io.continual.iam.credentials.JwtCredential;
import io.continual.iam.exceptions.IamSvcException;
import io.continual.iam.identity.JwtValidator;
import io.continual.util.data.Sha256HmacSigner;
import io.continual.util.data.TypeConvertor;
import io.continual.util.data.json.CommentedJsonTokener;
import io.continual.util.data.json.JsonVisitor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.Base64;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleJwtValidator
implements JwtValidator {
    private final String fName;
    private final String fAudience;
    private final TreeSet<String> fIssuers = new TreeSet();
    private final LinkedList<SigValidator> fSigValidators = new LinkedList();
    private static final Logger log = LoggerFactory.getLogger(SimpleJwtValidator.class);

    @Override
    public boolean validate(JwtCredential jwt) throws IamSvcException {
        String iss = jwt.getIssuer();
        if (!this.fIssuers.contains(iss)) {
            log.info("The JWT is not from an issuer the {} validator recognizes.", (Object)this.fName);
            return false;
        }
        if (!jwt.isForAudience(this.fAudience)) {
            log.info("The JWT is not for the {} validator's audience.", (Object)this.fName);
            return false;
        }
        List<SigValidator> validators = this.getValidators();
        for (SigValidator v : validators) {
            if (!v.validate(jwt)) continue;
            return true;
        }
        return false;
    }

    public List<SigValidator> getValidators() {
        LinkedList<SigValidator> result = new LinkedList<SigValidator>();
        result.addAll(this.fSigValidators);
        return result;
    }

    protected SimpleJwtValidator(Builder b) throws Builder.BuildFailure {
        this.fName = b.fName;
        this.fIssuers.addAll(b.fIssuers);
        this.fAudience = b.fAudience;
        if (b.fPublicKeyUrl != null) {
            this.fSigValidators.addAll(SimpleJwtValidator.readJwk(b.fPublicKeyUrl));
        }
        if (this.fIssuers.size() < 1) {
            throw new Builder.BuildFailure("No issuers specified for validator.");
        }
        if (this.fAudience == null || this.fAudience.length() == 0) {
            throw new Builder.BuildFailure("No audience specified for validator.");
        }
    }

    private static BigInteger stringToInt(String exponent) {
        byte[] unsignedBigEndianOctetSeq = TypeConvertor.base64UrlDecode((String)exponent);
        BigInteger bi = new BigInteger(1, unsignedBigEndianOctetSeq);
        return bi;
    }

    private static List<SigValidator> readJwk(String pkUrl) throws Builder.BuildFailure {
        log.info("Reading keys from {}", (Object)pkUrl);
        final LinkedList<SigValidator> result = new LinkedList<SigValidator>();
        try {
            URL url = new URL(pkUrl);
            URLConnection request = url.openConnection();
            request.connect();
            try (InputStream is = (InputStream)request.getContent();){
                JSONObject o = new JSONObject((JSONTokener)new CommentedJsonTokener(is));
                if (o.has("keys")) {
                    JsonVisitor.forEachElement((JSONArray)o.getJSONArray("keys"), (JsonVisitor.ArrayVisitor)new JsonVisitor.ArrayVisitor<JSONObject, GeneralSecurityException>(){

                        public boolean visit(JSONObject keyEntry) throws JSONException, GeneralSecurityException {
                            if (keyEntry.getString("kty").equals("RSA")) {
                                result.add(new RsaValidator(keyEntry));
                            }
                            return true;
                        }
                    });
                } else {
                    JsonVisitor.forEachElement((JSONObject)o, (JsonVisitor.ObjectVisitor)new JsonVisitor.ObjectVisitor<String, CertificateException>(){

                        public boolean visit(String key, String pem) throws CertificateException {
                            result.add(new RsaValidator(pem));
                            return true;
                        }
                    });
                }
            }
            catch (GeneralSecurityException x) {
                throw new Builder.BuildFailure((Throwable)x);
            }
            return result;
        }
        catch (IOException | JSONException e) {
            throw new Builder.BuildFailure(e);
        }
    }

    protected static interface SigValidator {
        public boolean validate(JwtCredential var1);
    }

    public static class Builder {
        private String fName = "(anonymous)";
        private String fAudience = "";
        private final TreeSet<String> fIssuers = new TreeSet();
        private String fPublicKeyUrl = null;

        public SimpleJwtValidator build() throws Builder.BuildFailure {
            return new SimpleJwtValidator(this);
        }

        public Builder named(String name) {
            this.fName = name;
            return this;
        }

        public Builder forIssuer(String iss) {
            this.fIssuers.add(iss);
            return this;
        }

        public Builder forAudience(String aud) {
            this.fAudience = aud;
            return this;
        }

        public Builder getPublicKeysFrom(String pkurl) {
            this.fPublicKeyUrl = pkurl;
            return this;
        }
    }

    protected static class RsaValidator
    implements SigValidator {
        private final PublicKey fPubKey;

        public RsaValidator(JSONObject keyEntry) throws NoSuchAlgorithmException, InvalidKeySpecException {
            BigInteger exponentBi = SimpleJwtValidator.stringToInt(keyEntry.getString("e"));
            BigInteger modBi = SimpleJwtValidator.stringToInt(keyEntry.getString("n"));
            RSAPublicKeySpec fKeySpec = new RSAPublicKeySpec(modBi, exponentBi);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            this.fPubKey = keyFactory.generatePublic(fKeySpec);
            String base64Enc = new String(Base64.getEncoder().encodeToString(this.fPubKey.getEncoded()));
            log.info("key is: {}", (Object)base64Enc);
        }

        public RsaValidator(String pem) throws CertificateException {
            CertificateFactory fact = CertificateFactory.getInstance("X.509");
            X509Certificate cer = (X509Certificate)fact.generateCertificate(new ByteArrayInputStream(pem.getBytes(StandardCharsets.UTF_8)));
            this.fPubKey = cer.getPublicKey();
        }

        @Override
        public boolean validate(JwtCredential jwt) {
            try {
                String signedPart = jwt.getSignedContent();
                String signature = jwt.getSignature();
                byte[] jwtSigBytes = TypeConvertor.base64UrlDecode((String)signature);
                Signature sig = Signature.getInstance("SHA256withRSA");
                sig.initVerify(this.fPubKey);
                sig.update(signedPart.getBytes(StandardCharsets.UTF_8));
                boolean verified = sig.verify(jwtSigBytes);
                return verified;
            }
            catch (GeneralSecurityException e) {
                log.warn("Unable to produce RSA with SHA-256 signature check.", (Throwable)e);
                return false;
            }
        }
    }

    protected static class Hs256SigValidator
    implements SigValidator {
        private final String fSecret;

        public Hs256SigValidator(String secret) {
            this.fSecret = secret;
        }

        @Override
        public boolean validate(JwtCredential jwt) {
            String signedPart = jwt.getSignedContent();
            String signature = jwt.getSignature();
            byte[] expectedSigBytes = Sha256HmacSigner.signToBytes((String)signedPart, (String)this.fSecret);
            String expectedSig = TypeConvertor.base64UrlEncode((byte[])expectedSigBytes);
            return expectedSig.equals(signature);
        }
    }
}

