/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.engine.library.processors;

import io.continual.services.processor.engine.model.MessageProcessingContext;
import io.continual.services.processor.engine.model.Processor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MapFields
implements Processor {
    private String[] fKeys = null;
    private String fToField = null;
    private ValueLookup fLookup = null;
    private final HashMap<Integer, String> fMap = new HashMap();

    public MapFields onKey(String ... keyFields) {
        this.fKeys = keyFields;
        return this;
    }

    public MapFields toField(String field) {
        this.fToField = field;
        return this;
    }

    public MapFields usingLookup(ValueLookup vl) {
        this.fLookup = vl;
        return this;
    }

    @Override
    public void process(MessageProcessingContext context) {
        if (this.fKeys == null || this.fToField == null || this.fLookup == null) {
            return;
        }
        ArrayList<String> vals = new ArrayList<String>();
        for (String key : this.fKeys) {
            vals.add(context.getMessage().getString(key));
        }
        int valHash = vals.hashCode();
        String result = this.fMap.get(valHash);
        if (result == null) {
            result = this.fLookup.lookup(vals);
            this.fMap.put(valHash, result);
        }
        context.getMessage().putValue(this.fToField, result);
    }

    public static interface ValueLookup {
        public String lookup(List<String> var1);
    }
}

