/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.engine.library.processors;

import io.continual.builder.Builder;
import io.continual.services.processor.config.readers.ConfigLoadContext;
import io.continual.services.processor.engine.model.Message;
import io.continual.services.processor.engine.model.MessageProcessingContext;
import io.continual.services.processor.engine.model.Processor;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public class DateFormat
implements Processor {
    private final String fFromField;
    private final DateFormatType fFromType;
    private final String fFromFormat;
    private final SimpleDateFormat fFromFormatter;
    private final String fToField;
    private final DateFormatType fToType;
    private final String fTargetFormat;
    private final SimpleDateFormat fToFormatter;

    public DateFormat(ConfigLoadContext sc, JSONObject config) throws Builder.BuildFailure {
        this(config);
    }

    public DateFormat(JSONObject config) throws Builder.BuildFailure {
        try {
            this.fFromField = config.getString("from");
            this.fFromFormat = config.getString("fromFormat");
            if (this.fFromFormat.startsWith("#sec")) {
                this.fFromType = DateFormatType.EPOCH_SECONDS;
                this.fFromFormatter = null;
            } else if (this.fFromFormat.startsWith("#milli") || this.fFromFormat.equals("#ms")) {
                this.fFromType = DateFormatType.EPOCH_MILLIS;
                this.fFromFormatter = null;
            } else {
                this.fFromType = DateFormatType.TEXT;
                this.fFromFormatter = new SimpleDateFormat(this.fFromFormat);
            }
            this.fToField = config.optString("to", null);
            this.fTargetFormat = config.getString("toFormat");
            if (this.fTargetFormat.startsWith("#sec")) {
                this.fToType = DateFormatType.EPOCH_SECONDS;
                this.fToFormatter = null;
            } else if (this.fTargetFormat.startsWith("#milli") || this.fFromFormat.equals("#ms")) {
                this.fToType = DateFormatType.EPOCH_MILLIS;
                this.fToFormatter = null;
            } else {
                this.fToType = DateFormatType.TEXT;
                this.fToFormatter = new SimpleDateFormat(this.fTargetFormat);
            }
        }
        catch (IllegalArgumentException | JSONException e) {
            throw new Builder.BuildFailure(e);
        }
    }

    @Override
    public void process(MessageProcessingContext context) {
        try {
            Message msg = context.getMessage();
            String fromVal = msg.getString(this.fFromField);
            long epochMs = 0L;
            switch (this.fFromType.ordinal()) {
                case 0: {
                    epochMs = Long.parseLong(fromVal) * 1000L;
                    break;
                }
                case 1: {
                    epochMs = Long.parseLong(fromVal);
                    break;
                }
                case 2: {
                    try {
                        epochMs = this.fFromFormatter.parse(fromVal).getTime();
                        break;
                    }
                    catch (ParseException e) {
                        context.warn("DateFormat could parse [" + fromVal + "] using [" + this.fFromFormatter + "].");
                        return;
                    }
                }
            }
            String result = "";
            switch (this.fToType.ordinal()) {
                case 0: {
                    result = Long.toString(epochMs / 1000L);
                    break;
                }
                case 1: {
                    result = Long.toString(epochMs);
                    break;
                }
                case 2: {
                    result = this.fToFormatter.format(new Date(epochMs));
                }
            }
            String to = this.fToField == null ? this.fFromField : this.fToField;
            msg.putValue(to, result);
        }
        catch (NumberFormatException x) {
            context.warn("Number format problem: " + x.getMessage());
        }
    }

    private static enum DateFormatType {
        EPOCH_SECONDS,
        EPOCH_MILLIS,
        TEXT;

    }
}

