/*
 * Decompiled with CFR 0.152.
 */
package io.continual.notify;

import io.continual.notify.ContinualAlertAgent;
import io.continual.notify.ContinualNotifier;
import io.continual.util.console.CmdLineParser;
import io.continual.util.console.CmdLinePrefs;
import io.continual.util.console.ConsoleProgram;
import io.continual.util.console.shell.Command;
import io.continual.util.console.shell.CommandList;
import io.continual.util.console.shell.ConsoleLooper;
import io.continual.util.console.shell.SimpleCommand;
import io.continual.util.console.shell.StdCommandList;
import io.continual.util.data.json.JsonUtil;
import io.continual.util.nv.NvReadable;
import java.io.PrintStream;
import java.util.HashMap;

public class NotifyConsole
extends ConsoleProgram {
    private final ContinualNotifier fNotifier = new ContinualNotifier().inForeground();
    private final ContinualAlertAgent fAlertAgent = new ContinualAlertAgent(this.fNotifier);
    private static final String kSubject = "subject";
    private static final String kCondition = "condition";
    private static final String kData = "data";

    protected ConsoleProgram.Looper init(NvReadable p, CmdLinePrefs clp) throws NvReadable.MissingReqdSettingException, NvReadable.InvalidSettingValueException, ConsoleProgram.StartupFailureException {
        return new ConsoleLooper(new String[]{"Notify Console"}, "> ", ". ", (CommandList)new CommandSet());
    }

    public static void main(String[] args) {
        try {
            NotifyConsole nc = new NotifyConsole();
            nc.runFromMain(args);
        }
        catch (ConsoleProgram.StartupFailureException | ConsoleProgram.UsageException | NvReadable.InvalidSettingValueException | NvReadable.LoadException | NvReadable.MissingReqdSettingException e) {
            e.printStackTrace();
        }
    }

    private class CommandSet
    extends StdCommandList {
        public CommandSet() {
            this.registerCommand((Command)new SubjCondCommand("notify"){

                protected ConsoleLooper.InputResult execute(HashMap<String, Object> workspace, CmdLinePrefs p, PrintStream outTo) throws ConsoleProgram.UsageException, NvReadable.MissingReqdSettingException {
                    String subject = p.getString(NotifyConsole.kSubject);
                    String condition = p.getString(NotifyConsole.kCondition);
                    NotifyConsole.this.fNotifier.onSubject(subject).withCondition(condition).send();
                    return ConsoleLooper.InputResult.kReady;
                }
            });
            this.registerCommand((Command)new SubjCondCommand("onset"){

                @Override
                protected void setupParser(CmdLineParser clp) {
                    super.setupParser(clp);
                    clp.registerOptionWithValue(NotifyConsole.kData, "d");
                }

                protected ConsoleLooper.InputResult execute(HashMap<String, Object> workspace, CmdLinePrefs p, PrintStream outTo) throws ConsoleProgram.UsageException, NvReadable.MissingReqdSettingException {
                    String subject = p.getString(NotifyConsole.kSubject);
                    String condition = p.getString(NotifyConsole.kCondition);
                    String data = p.getString(NotifyConsole.kData, null);
                    ContinualAlertAgent.Alert a = NotifyConsole.this.fAlertAgent.onset(subject, condition, data == null ? null : JsonUtil.readJsonObject((String)data));
                    CommandSet.this.outputAlert(a, outTo);
                    return ConsoleLooper.InputResult.kReady;
                }
            });
            this.registerCommand((Command)new SubjCondCommand("clear"){

                protected ConsoleLooper.InputResult execute(HashMap<String, Object> workspace, CmdLinePrefs p, PrintStream outTo) throws ConsoleProgram.UsageException, NvReadable.MissingReqdSettingException {
                    String subject = p.getString(NotifyConsole.kSubject);
                    String condition = p.getString(NotifyConsole.kCondition);
                    ContinualAlertAgent.Alert a = NotifyConsole.this.fAlertAgent.clear(subject, condition);
                    CommandSet.this.outputAlert(a, outTo);
                    return ConsoleLooper.InputResult.kReady;
                }
            });
            this.registerCommand((Command)new SimpleCommand("standing"){

                protected ConsoleLooper.InputResult execute(HashMap<String, Object> workspace, CmdLinePrefs p, PrintStream outTo) throws ConsoleProgram.UsageException, NvReadable.MissingReqdSettingException {
                    for (ContinualAlertAgent.Alert a : NotifyConsole.this.fAlertAgent.standingAlerts()) {
                        CommandSet.this.outputAlert(a, outTo);
                    }
                    return ConsoleLooper.InputResult.kReady;
                }
            });
        }

        protected void outputAlert(ContinualAlertAgent.Alert a, PrintStream outTo) {
            if (a == null) {
                outTo.println("No alert.");
            } else {
                outTo.println(a.toString());
            }
        }
    }

    private abstract class SubjCondCommand
    extends SimpleCommand {
        public SubjCondCommand(String msg) {
            super(msg);
        }

        protected void setupParser(CmdLineParser clp) {
            clp.registerOptionWithValue(NotifyConsole.kSubject, "s");
            clp.registerOptionWithValue(NotifyConsole.kCondition, "c");
        }
    }
}

