/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.time;

import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Clock {
    private static final Logger log = LoggerFactory.getLogger(Clock.class);

    public static long now() {
        return holder.instance.nowMs();
    }

    public static void replaceClock(Clock c) {
        holder.instance = c;
    }

    public static TestClock useNewTestClock() {
        TestClock tc = new TestClock();
        Clock.replaceClock(tc);
        return tc;
    }

    protected long nowMs() {
        return System.currentTimeMillis();
    }

    public static class ScaledClock
    extends Clock {
        private final long fStartMs;
        private final double fScale;

        public ScaledClock() {
            String timeStart = System.getProperty("timeStart");
            String timeScale = System.getProperty("timeScale");
            long startMs = System.currentTimeMillis();
            if (timeStart != null) {
                try {
                    startMs = Long.parseLong(timeStart);
                    if (startMs < 0L) {
                        startMs = System.currentTimeMillis() + startMs;
                    }
                }
                catch (NumberFormatException x) {
                    log.warn("Couldn't parse timeStart: " + x.getMessage());
                    startMs = System.currentTimeMillis();
                }
            }
            double scale = 1.0;
            if (timeScale != null) {
                try {
                    scale = Double.parseDouble(timeScale);
                    if (scale <= 0.0) {
                        log.warn("Time scale must be a positive number.");
                        scale = 1.0;
                    }
                }
                catch (NumberFormatException x) {
                    log.warn("Couldn't parse timeScale: " + x.getMessage());
                    scale = 1.0;
                }
            }
            this.fStartMs = startMs;
            this.fScale = scale;
        }

        @Override
        public long nowMs() {
            return this.fStartMs + Math.round((double)(super.nowMs() - this.fStartMs) * this.fScale);
        }
    }

    public static class TestClock
    extends Clock {
        private long nowMs = 1L;

        @Override
        public long nowMs() {
            return this.nowMs;
        }

        public TestClock set(long ms) {
            this.nowMs = ms;
            return this;
        }

        public TestClock add(long ms) {
            this.nowMs += ms;
            return this;
        }

        public TestClock add(long val, TimeUnit tu) {
            return this.add(TimeUnit.MILLISECONDS.convert(val, tu));
        }
    }

    private static class holder {
        static volatile Clock instance = null == System.getProperty("timeStart") && null == System.getProperty("timeScale") ? new Clock() : new ScaledClock();

        private holder() {
        }
    }
}

