/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.nv.impl;

import io.continual.util.nv.NvReadable;
import io.continual.util.nv.impl.nvBaseReadable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.slf4j.LoggerFactory;

public class nvInstallTypeWrapper
extends nvBaseReadable {
    private final NvReadable fActual;
    private final TreeSet<String> fKeys;
    private final String fSystemType;
    private final String fThisUser;

    public nvInstallTypeWrapper(NvReadable actual) {
        this.fActual = actual;
        this.fKeys = new TreeSet();
        this.fThisUser = System.getProperty("user.name");
        this.fSystemType = System.getProperty("rr.installation", null);
        if (this.fSystemType != null) {
            LoggerFactory.getLogger(nvInstallTypeWrapper.class).info("rr.installation: " + this.fSystemType);
        }
        this.parseForKeys();
    }

    @Override
    public int size() {
        return this.fKeys.size();
    }

    @Override
    public Collection<String> getAllKeys() {
        return this.fKeys;
    }

    @Override
    public Map<String, String> getCopyAsMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : this.fKeys) {
            map.put(key, this.getString(key, ""));
        }
        return map;
    }

    @Override
    public boolean hasValueFor(String key) {
        return this.fKeys.contains(key);
    }

    @Override
    public String getString(String key) throws NvReadable.MissingReqdSettingException {
        String keyToTry;
        String result = null;
        if (this.fSystemType != null && this.fThisUser != null) {
            keyToTry = key + "[" + this.fSystemType + "@" + this.fThisUser + "]";
            result = this.fActual.getString(keyToTry, null);
        }
        if (result == null && this.fSystemType != null) {
            keyToTry = key + "[" + this.fSystemType + "]";
            result = this.fActual.getString(keyToTry, null);
        }
        if (result == null && this.fThisUser != null) {
            keyToTry = key + "[@" + this.fThisUser + "]";
            result = this.fActual.getString(keyToTry, null);
        }
        if (result == null) {
            result = this.fActual.getString(key);
        }
        return result;
    }

    @Override
    public String[] getStrings(String key) throws NvReadable.MissingReqdSettingException {
        String keyToTry;
        String[] result = null;
        if (this.fSystemType != null && this.fThisUser != null) {
            keyToTry = key + "[" + this.fSystemType + "@" + this.fThisUser + "]";
            result = this.fActual.getStrings(keyToTry, null);
        }
        if (result == null && this.fSystemType != null) {
            keyToTry = key + "[" + this.fSystemType + "]";
            result = this.fActual.getStrings(keyToTry, null);
        }
        if (result == null && this.fThisUser != null) {
            keyToTry = key + "[@" + this.fThisUser + "]";
            result = this.fActual.getStrings(keyToTry, null);
        }
        if (result == null) {
            result = this.fActual.getStrings(key);
        }
        return result;
    }

    @Override
    public void rescan() throws NvReadable.LoadException {
        super.rescan();
        this.parseForKeys();
    }

    private void parseForKeys() {
        this.fKeys.clear();
        for (String key : this.fActual.getAllKeys()) {
            this.fKeys.add(nvInstallTypeWrapper.parse(key));
        }
    }

    static String parse(String key) {
        if ((key = key.trim()).matches(".*\\[[^\\[\\]]+\\]")) {
            int openBracket = key.indexOf(91);
            key = key.substring(0, openBracket);
        }
        return key;
    }
}

