/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.data.base64;

import io.continual.util.data.base64.Base64Constants;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;

public class Base64OutputStream
extends OutputStream {
    private static final int kMaxLine = 80;
    private static final int kBufferSize = 192;
    private OutputStream fDownstream;
    private int fWrittenToLine;
    private final LinkedList<Byte> fPendings;
    private final int fMaxLine;

    public Base64OutputStream(OutputStream downstream) {
        this(downstream, 80);
    }

    public Base64OutputStream(OutputStream downstream, int maxPerLine) {
        this.fDownstream = downstream;
        this.fPendings = new LinkedList();
        this.fWrittenToLine = 0;
        this.fMaxLine = maxPerLine > 0 ? maxPerLine : 80;
    }

    @Override
    public void write(int b) throws IOException {
        this.fPendings.add((byte)b);
        this.writePendings(false);
    }

    @Override
    public void close() throws IOException {
        this.writePendings(true);
        this.fDownstream.close();
    }

    private int writeNow() {
        int result = 0;
        int pending = this.fPendings.size();
        if (pending > 192) {
            result = 192;
        }
        return result;
    }

    private void writePendings(boolean pad) throws IOException {
        int thisWrite = this.fPendings.size();
        if (!pad) {
            thisWrite = this.writeNow();
        }
        if (thisWrite > 0) {
            char[] cc;
            byte[] bb = new byte[thisWrite];
            for (int i = 0; i < thisWrite; ++i) {
                bb[i] = this.fPendings.remove();
            }
            for (char c : cc = this.encode(bb)) {
                this.fDownstream.write(c);
                if (++this.fWrittenToLine != this.fMaxLine) continue;
                this.fDownstream.write(10);
                this.fWrittenToLine = 0;
            }
        }
    }

    private char[] encode(byte[] in) {
        int iLen = in.length;
        int oDataLen = (iLen * 4 + 2) / 3;
        int oLen = (iLen + 2) / 3 * 4;
        char[] out = new char[oLen];
        int ip = 0;
        int op = 0;
        while (ip < iLen) {
            int i0 = in[ip++] & 0xFF;
            int i1 = ip < iLen ? in[ip++] & 0xFF : 0;
            int i2 = ip < iLen ? in[ip++] & 0xFF : 0;
            int o0 = i0 >>> 2;
            int o1 = (i0 & 3) << 4 | i1 >>> 4;
            int o2 = (i1 & 0xF) << 2 | i2 >>> 6;
            int o3 = i2 & 0x3F;
            out[op++] = Base64Constants.nibblesToB64[o0];
            out[op++] = Base64Constants.nibblesToB64[o1];
            out[op] = op < oDataLen ? Base64Constants.nibblesToB64[o2] : 61;
            int n = ++op < oDataLen ? Base64Constants.nibblesToB64[o3] : 61;
            out[op] = n;
            ++op;
        }
        return out;
    }
}

