/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.console;

import io.continual.util.console.BackgroundLooper;
import io.continual.util.console.CmdLinePrefs;
import io.continual.util.console.ConfiguredConsole;
import io.continual.util.console.ConsoleProgram;
import io.continual.util.legal.CopyrightGenerator;
import io.continual.util.nv.NvReadable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DaemonConsole
extends ConfiguredConsole {
    private final String fName;
    private final CopyrightGenerator fCopy;
    private boolean fQuiet = false;
    private static final Logger log = LoggerFactory.getLogger(DaemonConsole.class);

    protected DaemonConsole(String programName) {
        this.fName = programName;
        this.fCopy = new CopyrightGenerator();
    }

    protected String getProgramName() {
        return this.fName;
    }

    protected DaemonConsole registerCopyrightHolder(String holder2, int startYear) {
        this.fCopy.addHolder(holder2, startYear);
        return this;
    }

    @Override
    protected ConsoleProgram.Looper init(NvReadable p, CmdLinePrefs clp) throws NvReadable.MissingReqdSettingException, NvReadable.InvalidSettingValueException, ConsoleProgram.StartupFailureException {
        if (!this.fQuiet) {
            System.out.println(this.fName);
            for (String notice : this.getCopyrightLines()) {
                System.out.println(notice);
            }
        }
        return new BackgroundLooper(3000){

            @Override
            public boolean stillRunning() {
                return DaemonConsole.this.daemonStillRunning();
            }

            @Override
            public void teardown(NvReadable p) {
                DaemonConsole.this.daemonShutdown();
            }
        };
    }

    protected boolean daemonStillRunning() {
        log.warn("The daemon class must implement daemonStillRunning(). (And don't call the base class implementation.)");
        return false;
    }

    protected void daemonShutdown() {
    }

    protected void quietStartup() {
        this.fQuiet = true;
    }

    protected List<String> getCopyrightLines() {
        return this.fCopy.getCopyrightNotices();
    }
}

