/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.console;

import io.continual.util.console.CmdLineParser;
import io.continual.util.console.CmdLinePrefs;
import io.continual.util.console.ConsoleProgram;
import io.continual.util.nv.NvReadable;
import io.continual.util.nv.NvWriteable;
import io.continual.util.nv.impl.nvPropertiesFile;
import java.io.File;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfiguredConsole
extends ConsoleProgram {
    public static final String kConfigFile = "config";
    public static final String kConfigFileChar = "c";
    private final String fShortName;
    private static final Logger log = LoggerFactory.getLogger(ConfiguredConsole.class);

    protected ConfiguredConsole() {
        this(null);
    }

    protected ConfiguredConsole(String shortName) {
        this.fShortName = shortName;
    }

    @Override
    protected abstract ConsoleProgram.Looper init(NvReadable var1, CmdLinePrefs var2) throws NvReadable.MissingReqdSettingException, NvReadable.InvalidSettingValueException, ConsoleProgram.StartupFailureException;

    @Override
    protected ConfiguredConsole setupDefaults(NvWriteable pt) {
        return this;
    }

    @Override
    protected ConfiguredConsole setupOptions(CmdLineParser p) {
        super.setupOptions(p);
        p.registerOptionWithValue(kConfigFile, kConfigFileChar, null, null);
        return this;
    }

    protected NvReadable loadFile(String name) throws NvReadable.LoadException {
        nvPropertiesFile result = null;
        File cf = new File(name);
        if (cf.exists()) {
            result = new nvPropertiesFile(cf);
        } else {
            log.warn("Couldn't load configuration file [" + name + "].");
        }
        return result;
    }

    @Override
    protected NvReadable loadAdditionalConfig(NvReadable currentPrefs) throws NvReadable.LoadException {
        String cfn = currentPrefs.getString(kConfigFile, null);
        if (cfn != null) {
            return this.loadFile(cfn);
        }
        if (this.fShortName != null) {
            String props = this.fShortName + ".properties";
            URL url = ConfiguredConsole.class.getClassLoader().getResource(props);
            if (url != null) {
                return new nvPropertiesFile(url);
            }
            props = "etc/" + props;
            return this.loadFile(props);
        }
        return null;
    }
}

