/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.collections;

import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MultiMap<K, V> {
    private final Hashtable<K, List<V>> fMultiMap = new Hashtable();

    public MultiMap() {
    }

    public MultiMap(Map<K, V> data2) {
        this();
        for (Map.Entry<K, V> e : data2.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    public MultiMap<K, V> clone() {
        MultiMap<K, V> newMap = new MultiMap<K, V>();
        for (Map.Entry<K, List<V>> e : this.fMultiMap.entrySet()) {
            K key = e.getKey();
            newMap.put(key, (Collection<V>)this.get(key));
        }
        return newMap;
    }

    public String toString() {
        return this.fMultiMap.toString();
    }

    public synchronized void put(K k) {
        this.getOrCreateFor(k);
    }

    public synchronized void put(K k, V v) {
        LinkedList<V> list = new LinkedList<V>();
        list.add(v);
        this.put(k, (Collection<V>)list);
    }

    public synchronized void put(K k, Collection<V> v) {
        List<V> itemList = this.getOrCreateFor(k);
        itemList.removeAll(v);
        itemList.addAll(v);
    }

    public synchronized void putAll(Map<K, ? extends Collection<V>> values) {
        for (Map.Entry<K, Collection<V>> e : values.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    public synchronized boolean containsKey(K k) {
        return this.fMultiMap.containsKey(k);
    }

    public synchronized List<V> get(K k) {
        List<Object> itemList = new LinkedList();
        if (this.fMultiMap.containsKey(k)) {
            itemList = this.getOrCreateFor(k);
        }
        return new LinkedList(itemList);
    }

    public V getFirst(K k) {
        List<V> items = this.get(k);
        if (items.size() > 0) {
            return items.get(0);
        }
        return null;
    }

    public synchronized Collection<K> getKeys() {
        return this.fMultiMap.keySet();
    }

    public synchronized Map<K, List<V>> getValues() {
        return this.fMultiMap;
    }

    public synchronized Map<K, Collection<V>> getCopyAsSimpleMap() {
        HashMap result = new HashMap();
        for (Map.Entry<K, List<V>> e : this.fMultiMap.entrySet()) {
            LinkedList list = new LinkedList();
            list.addAll(e.getValue());
            result.put(e.getKey(), list);
        }
        return result;
    }

    public synchronized List<V> remove(K k) {
        return this.fMultiMap.remove(k);
    }

    public synchronized void remove(K k, V v) {
        List<V> itemList = this.getOrCreateFor(k);
        itemList.remove(v);
    }

    public synchronized void clear() {
        this.fMultiMap.clear();
    }

    public synchronized int size() {
        return this.fMultiMap.size();
    }

    public synchronized int size(K k) {
        return this.getOrCreateFor(k).size();
    }

    private synchronized List<V> getOrCreateFor(K k) {
        List<V> itemList = this.fMultiMap.get(k);
        if (itemList == null) {
            itemList = new LinkedList<V>();
            this.fMultiMap.put(k, itemList);
        }
        return itemList;
    }
}

