/*
 * Decompiled with CFR 0.152.
 */
package io.continual.templating;

import com.github.f4b6a3.ulid.Ulid;
import io.continual.resources.ResourceLoader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import org.slf4j.LoggerFactory;

public interface ContinualTemplateSource
extends AutoCloseable {
    public String getName();

    public InputStream getTemplate() throws TemplateNotFoundException;

    @Override
    default public void close() throws Exception {
    }

    public static ContinualTemplateSource fromString(final String stringVal) {
        return new ContinualTemplateSource(){

            @Override
            public InputStream getTemplate() throws TemplateNotFoundException {
                return new ByteArrayInputStream(stringVal.getBytes(StandardCharsets.UTF_8));
            }

            @Override
            public String getName() {
                return stringVal;
            }
        };
    }

    public static ContinualTemplateSource fromResource(final String resName, final String relativeName) {
        return new ContinualTemplateSource(){
            InputStream is = null;

            @Override
            public String getName() {
                return relativeName;
            }

            @Override
            public InputStream getTemplate() throws TemplateNotFoundException {
                try {
                    this.is = ResourceLoader.load((String)resName);
                    if (this.is == null) {
                        LoggerFactory.getLogger(ContinualTemplateSource.class).warn("Couldn't load resource {}", (Object)resName);
                        throw new TemplateNotFoundException("Couldn't load resource " + resName);
                    }
                    return this.is;
                }
                catch (IOException e) {
                    throw new TemplateNotFoundException(e);
                }
            }

            @Override
            public void close() throws IOException {
                if (this.is != null) {
                    this.is.close();
                }
            }
        };
    }

    public static ContinualTemplateSource fromFile(final File file) {
        return new ContinualTemplateSource(){
            FileInputStream fFile = null;

            @Override
            public String getName() {
                return file.getName();
            }

            @Override
            public InputStream getTemplate() throws TemplateNotFoundException {
                if (this.fFile != null) {
                    throw new IllegalStateException("Template was already retrieved.");
                }
                try {
                    this.fFile = new FileInputStream(file);
                    return this.fFile;
                }
                catch (FileNotFoundException e) {
                    throw new TemplateNotFoundException(e);
                }
            }

            @Override
            public void close() throws IOException {
                if (this.fFile != null) {
                    this.fFile.close();
                }
            }
        };
    }

    public static ContinualTemplateSource fromInputStream(InputStream is) {
        return ContinualTemplateSource.fromInputStream(is, "input stream " + Ulid.fast().toLowerCase());
    }

    public static ContinualTemplateSource fromInputStream(final InputStream is, final String uniqueName) {
        return new ContinualTemplateSource(){

            @Override
            public String getName() {
                return uniqueName;
            }

            @Override
            public InputStream getTemplate() {
                return is;
            }

            @Override
            public void close() throws IOException {
                is.close();
            }
        };
    }

    public static ContinualTemplateSource combinedStreams(final ContinualTemplateSource ... streams) {
        return new ContinualTemplateSource(){

            @Override
            public String getName() {
                StringBuilder sb = new StringBuilder();
                for (ContinualTemplateSource src : streams) {
                    if (sb.length() > 0) {
                        sb.append(" + ");
                    }
                    sb.append(src.getName());
                }
                return sb.toString();
            }

            @Override
            public InputStream getTemplate() throws TemplateNotFoundException {
                final LinkedList<InputStream> srcs = new LinkedList<InputStream>();
                for (ContinualTemplateSource src : streams) {
                    srcs.add(src.getTemplate());
                }
                return new InputStream(){

                    @Override
                    public int read() throws IOException {
                        while (!srcs.isEmpty()) {
                            InputStream currentStream = (InputStream)srcs.peek();
                            int data = currentStream.read();
                            if (data == -1) {
                                srcs.remove();
                                continue;
                            }
                            return data;
                        }
                        return -1;
                    }
                };
            }

            @Override
            public void close() throws Exception {
                for (ContinualTemplateSource src : streams) {
                    src.close();
                }
            }
        };
    }

    public static class TemplateNotFoundException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public TemplateNotFoundException(String msg) {
            super(msg);
        }

        public TemplateNotFoundException(Throwable t) {
            super(t);
        }
    }
}

