/*
 * Decompiled with CFR 0.152.
 */
package io.continual.jsonHttpClient.impl.ok;

import io.continual.jsonHttpClient.HttpUsernamePasswordCredentials;
import io.continual.jsonHttpClient.JsonOverHttpClient;
import io.continual.jsonHttpClient.impl.ok.OkResponse;
import io.continual.util.data.TypeConvertor;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import okhttp3.Credentials;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OkRequest
implements JsonOverHttpClient.HttpRequest {
    private final OkHttpClient fHttpClient;
    private String fPath;
    private HttpUsernamePasswordCredentials fCreds;
    private HashMap<String, List<String>> fHeaders;
    private String fQueryString = null;
    private HashMap<String, String> fQueryParams = null;
    private static final Logger log = LoggerFactory.getLogger(OkRequest.class);

    public OkRequest(OkHttpClient httpClient) {
        this.fHttpClient = httpClient;
        this.fHeaders = new HashMap();
    }

    @Override
    public JsonOverHttpClient.HttpRequest onPath(String url) {
        this.fPath = url;
        return this;
    }

    @Override
    public JsonOverHttpClient.HttpRequest asUser(HttpUsernamePasswordCredentials creds) {
        this.fCreds = creds;
        return this;
    }

    @Override
    public JsonOverHttpClient.HttpRequest withHeader(String name, String value) {
        List<String> set = this.fHeaders.get(name);
        if (set == null) {
            set = new LinkedList<String>();
            this.fHeaders.put(name, set);
        }
        set.add(value);
        return this;
    }

    @Override
    public JsonOverHttpClient.HttpRequest withHeaders(Map<String, String> headers) {
        for (Map.Entry<String, String> e : headers.entrySet()) {
            this.withHeader(e.getKey(), e.getValue());
        }
        return this;
    }

    @Override
    public JsonOverHttpClient.HttpRequest withExplicitQueryString(String qs) {
        this.fQueryString = qs;
        this.fQueryParams = null;
        return this;
    }

    @Override
    public JsonOverHttpClient.HttpRequest addQueryParam(String key, String val) {
        this.fQueryString = null;
        if (this.fQueryParams == null) {
            this.fQueryParams = new HashMap();
        }
        this.fQueryParams.put(key, val);
        return this;
    }

    @Override
    public JsonOverHttpClient.HttpRequest withQueryString(Map<String, String> qsMap) {
        for (Map.Entry<String, String> e : qsMap.entrySet()) {
            this.addQueryParam(e.getKey(), e.getValue());
        }
        return this;
    }

    private Request.Builder basicReq() {
        String path = this.fPath;
        if (this.fQueryString != null && this.fQueryString.length() > 0) {
            path = path + "?" + this.fQueryString;
        } else if (this.fQueryParams != null && this.fQueryParams.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, Object> entry : this.fQueryParams.entrySet()) {
                if (sb.length() > 0) {
                    sb.append("&");
                }
                sb.append(entry.getKey()).append("=").append(TypeConvertor.urlEncode((String)((String)entry.getValue())));
            }
            path = path + "?" + sb.toString();
        }
        Request.Builder rb = new Request.Builder().url(path);
        if (this.fCreds != null) {
            rb = rb.header("Authorization", Credentials.basic((String)this.fCreds.getUser(), (String)this.fCreds.getPassword()));
        }
        for (Map.Entry<String, Object> entry : this.fHeaders.entrySet()) {
            for (String val : (List)entry.getValue()) {
                rb.addHeader(entry.getKey(), val);
            }
        }
        return rb;
    }

    @Override
    public JsonOverHttpClient.HttpResponse get() throws JsonOverHttpClient.HttpServiceException {
        return this.run("GET", this.basicReq().build());
    }

    @Override
    public JsonOverHttpClient.HttpResponse delete() throws JsonOverHttpClient.HttpServiceException {
        return this.run("DEL", this.basicReq().delete().build());
    }

    @Override
    public JsonOverHttpClient.HttpResponse put(JSONObject body) throws JsonOverHttpClient.HttpServiceException {
        RequestBody rb = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)body.toString());
        return this.run("PUT", this.basicReq().put(rb).build());
    }

    @Override
    public JsonOverHttpClient.HttpResponse patch(JSONObject body) throws JsonOverHttpClient.HttpServiceException {
        RequestBody rb = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)body.toString());
        return this.run("PAT", this.basicReq().patch(rb).build());
    }

    @Override
    public JsonOverHttpClient.HttpResponse post(JSONObject body) throws JsonOverHttpClient.HttpServiceException {
        RequestBody rb = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)body.toString());
        return this.run("POS", this.basicReq().post(rb).build());
    }

    @Override
    public JsonOverHttpClient.HttpResponse post(JSONArray body) throws JsonOverHttpClient.HttpServiceException {
        RequestBody rb = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)body.toString());
        return this.run("POS", this.basicReq().post(rb).build());
    }

    private JsonOverHttpClient.HttpResponse run(String verbForLog, Request request) throws JsonOverHttpClient.HttpServiceException {
        try {
            String user = this.fCreds == null ? " (anon)" : " (as " + this.fCreds.getUser() + ")";
            log.info("HTTP {} " + this.fPath + user, (Object)verbForLog);
            long startMs = System.nanoTime();
            Response response = this.fHttpClient.newCall(request).execute();
            long endMs = System.nanoTime();
            int code = response.code();
            log.info("    -> {}; {} ms", (Object)code, (Object)((endMs - startMs) / 1000L / 1000L));
            return new OkResponse(code, response);
        }
        catch (IOException | JSONException e) {
            throw new JsonOverHttpClient.HttpServiceException(e);
        }
    }
}

