/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.messaging.impl.kafka;

import io.continual.builder.Builder;
import io.continual.messaging.ContinualMessage;
import io.continual.messaging.ContinualMessagePublisher;
import io.continual.messaging.ContinualMessageSink;
import io.continual.messaging.ContinualMessageStream;
import io.continual.messaging.MessagePublishException;
import io.continual.services.ServiceContainer;
import io.continual.services.SimpleService;
import io.continual.util.data.json.JsonVisitor;
import java.io.IOException;
import java.util.Collection;
import java.util.Properties;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaPublisher
extends SimpleService
implements ContinualMessagePublisher {
    private final KafkaProducer<String, String> fProducer;
    private static final Logger log = LoggerFactory.getLogger(KafkaPublisher.class);

    public KafkaPublisher(ServiceContainer sc, JSONObject rawConfig) throws Builder.BuildFailure {
        JSONObject config = sc.getExprEval().evaluateJsonObject(rawConfig);
        final Properties props = new Properties();
        props.put("acks", "all");
        props.put("retries", (Object)0);
        props.put("batch.size", (Object)16384);
        props.put("linger.ms", (Object)1);
        props.put("buffer.memory", (Object)0x2000000);
        props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        JsonVisitor.forEachElement((JSONObject)config.optJSONObject("kafka"), (JsonVisitor.ObjectVisitor)new JsonVisitor.ObjectVisitor<Object, Builder.BuildFailure>(){

            public boolean visit(String key, Object t) throws JSONException, Builder.BuildFailure {
                props.put(key, t.toString());
                return true;
            }
        });
        this.fProducer = new KafkaProducer(props);
    }

    public ContinualMessageSink getTopic(final String topic) throws ContinualMessagePublisher.TopicUnavailableException {
        return new ContinualMessageSink(){

            public void send(ContinualMessageStream stream, Collection<ContinualMessage> msgs) throws MessagePublishException {
                for (ContinualMessage msg : msgs) {
                    String partition = stream.getName();
                    String payload = msg.toJson().toString();
                    log.info("To Kafka (" + topic + " / " + partition + "): " + payload);
                    KafkaPublisher.this.fProducer.send(new ProducerRecord(topic.toString(), (Object)partition, (Object)payload));
                }
                KafkaPublisher.this.fProducer.flush();
            }
        };
    }

    public void flush() {
    }

    public void close() throws IOException {
        this.fProducer.close();
    }
}

