/*
 * Decompiled with CFR 0.152.
 */
package io.continual.notify;

import io.continual.util.data.StreamTools;
import io.continual.util.data.exprEval.EnvDataSource;
import io.continual.util.data.exprEval.ExprDataSource;
import io.continual.util.data.exprEval.ExpressionEvaluator;
import io.continual.util.standards.HttpStatusCodes;
import io.continual.util.time.Clock;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContinualNotifier {
    private String fTopic = null;
    private String fStream = null;
    private JSONObject fMsg = new JSONObject();
    private String fUser = ContinualNotifier.evalSetting("CONTINUAL_USER");
    private String fPassword = ContinualNotifier.evalSetting("CONTINUAL_PASSWORD");
    private boolean fBackground = true;
    private String fSourceSystem = null;
    private static final String kVersionTag = "ver";
    private static final String kVersion = "1.0";
    private static final String kSubject = "subj";
    private static final String kCondition = "cond";
    private static final String kDetails = "details";
    private static final String kOnset = "onset";
    private static final String kQueuedAt = "queuedAt";
    private static final String kSendAt = "sentAt";
    private static final String skBaseUrlStr = "https://rcvr.continual.io/events";
    private static final ExpressionEvaluator skEval = new ExpressionEvaluator(new ExprDataSource[]{new EnvDataSource()});
    private static final Logger log = LoggerFactory.getLogger(ContinualNotifier.class);
    private static ExecutorService skBackgroundSender = Executors.newSingleThreadExecutor();

    public static void send(String subject, String condition) {
        new ContinualNotifier().onSubject(subject).withCondition(condition).send();
    }

    public ContinualNotifier() {
        this.fTopic = ContinualNotifier.evalSetting("CONTINUAL_RCVR_TOPIC");
        this.fSourceSystem = ContinualNotifier.evalSetting("CONTINUAL_SYSTEM");
        if (this.fSourceSystem != null && this.fSourceSystem.length() > 0) {
            this.onSubject(this.fSourceSystem);
        }
        this.fStream = ContinualNotifier.evalSetting("CONTINUAL_RCVR_STREAM");
        if (this.fStream == null && this.fSourceSystem != null && this.fSourceSystem.length() > 0) {
            this.fStream = this.fSourceSystem;
        }
        this.fMsg.put(kVersionTag, (Object)kVersion);
    }

    public ContinualNotifier toTopic(String topic) {
        this.fTopic = topic;
        return this;
    }

    public ContinualNotifier onStream(String stream) {
        this.fStream = stream;
        return this;
    }

    public ContinualNotifier asUser(String user, String pwd) {
        if (user == null || user.length() == 0) {
            throw new IllegalArgumentException("Provide a username.");
        }
        if (pwd == null || pwd.length() == 0) {
            throw new IllegalArgumentException("Provide a password.");
        }
        this.fUser = user;
        this.fPassword = pwd;
        return this;
    }

    public ContinualNotifier inForeground() {
        this.fBackground = false;
        return this;
    }

    public ContinualNotifier inBackground() {
        this.fBackground = true;
        return this;
    }

    public ContinualNotifier onSubject(String subject) {
        if (subject == null) {
            throw new IllegalArgumentException("Provide a subject.");
        }
        this.fMsg.put(kSubject, (Object)subject);
        return this;
    }

    public ContinualNotifier withCondition(String condition) {
        if (condition == null) {
            throw new IllegalArgumentException("Provide a subject.");
        }
        this.fMsg.put(kCondition, (Object)condition);
        return this;
    }

    public ContinualNotifier asOnset() {
        this.fMsg.put(kOnset, true);
        return this;
    }

    public ContinualNotifier asClear() {
        this.fMsg.put(kOnset, false);
        return this;
    }

    public ContinualNotifier withDetails(String details) {
        if (details == null) {
            throw new IllegalArgumentException("Provide details.");
        }
        this.fMsg.put(kDetails, (Object)details);
        return this;
    }

    public ContinualNotifier withAddlData(String key, Object val) {
        this.fMsg.put(key, val);
        return this;
    }

    public void send() {
        this.withAddlData(kQueuedAt, Clock.now());
        Sender mySender = new Sender();
        if (this.fBackground) {
            skBackgroundSender.submit(mySender);
        } else {
            mySender.run();
        }
    }

    private static String formatLog(String msg) {
        return "Continual.Notifier " + msg;
    }

    private static void debug(String msg) {
        log.info(ContinualNotifier.formatLog(msg));
    }

    private static void warn(String msg) {
        log.warn(ContinualNotifier.formatLog(msg));
    }

    private static String evalSetting(String key) {
        String val = skEval.evaluateText("${" + key + "}");
        return val == null || val.length() == 0 ? null : val;
    }

    private class Sender
    implements Runnable {
        private Sender() {
        }

        @Override
        public void run() {
            if (ContinualNotifier.this.fUser == null || ContinualNotifier.this.fPassword == null) {
                ContinualNotifier.warn("Skipping message send because credentials are not set.");
                return;
            }
            try {
                String urlText = ContinualNotifier.skBaseUrlStr;
                if (ContinualNotifier.this.fTopic != null) {
                    urlText = urlText + "/" + URLEncoder.encode(ContinualNotifier.this.fTopic, StandardCharsets.UTF_8.toString());
                    if (ContinualNotifier.this.fStream != null) {
                        urlText = urlText + "/" + URLEncoder.encode(ContinualNotifier.this.fStream, StandardCharsets.UTF_8.toString());
                    }
                }
                URL url = new URL(urlText);
                byte[] payload = ContinualNotifier.this.fMsg.put(ContinualNotifier.kSendAt, Clock.now()).toString().getBytes(StandardCharsets.UTF_8);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Content-Type", "application/json");
                conn.setConnectTimeout(15000);
                String authString = ContinualNotifier.this.fUser + ":" + ContinualNotifier.this.fPassword;
                String encodedAuthString = Base64.getEncoder().encodeToString(authString.getBytes(StandardCharsets.UTF_8));
                conn.setRequestProperty("Authorization", "Basic " + encodedAuthString);
                conn.setDoInput(true);
                conn.setDoOutput(true);
                conn.setRequestProperty("Content-Length", String.valueOf(payload.length));
                conn.getOutputStream().write(payload);
                int responseCode = conn.getResponseCode();
                byte[] response = StreamTools.readBytes((InputStream)conn.getInputStream());
                if (HttpStatusCodes.isSuccess((int)responseCode)) {
                    ContinualNotifier.debug("ok: " + responseCode + " " + new String(response).trim());
                } else {
                    ContinualNotifier.warn("failed: " + responseCode);
                }
                conn.disconnect();
            }
            catch (IOException e) {
                ContinualNotifier.warn("failed with exception: " + e.getMessage());
            }
        }
    }
}

