/*
 * Decompiled with CFR 0.152.
 */
package io.continual.iam.tools;

import io.continual.iam.exceptions.IamSvcException;
import io.continual.iam.impl.common.CommonJsonGroup;
import io.continual.iam.impl.common.CommonJsonIdentity;
import io.continual.iam.impl.s3.S3IamDb;
import io.continual.util.console.CmdLinePrefs;
import io.continual.util.console.ConsoleProgram;
import io.continual.util.nv.NvReadable;
import java.util.Vector;

public class S3MigrateToNewGroups
extends ConsoleProgram {
    protected ConsoleProgram.Looper init(NvReadable p, CmdLinePrefs cmdLine) {
        Vector args = cmdLine.getFileArguments();
        if (args.size() < 4) {
            System.err.print("usage: " + ((Object)((Object)this)).getClass().getSimpleName() + " <awsKey> <awsSecret> <bucket> <prefix>");
            return null;
        }
        try {
            S3IamDb db = new S3IamDb.Builder().withAccessKey((String)args.get(0)).withSecretKey((String)args.get(1)).withBucket((String)args.get(2)).withPathPrefix((String)args.get(3)).build();
            for (String user : db.getAllUsers()) {
                System.out.println(user);
                CommonJsonIdentity ii = db.loadUser(user);
                for (String groupId : ii.getGroupIds()) {
                    System.out.println("\t" + groupId);
                    CommonJsonGroup g = db.loadGroup(groupId);
                    g.addUser(user);
                }
            }
        }
        catch (IamSvcException e) {
            System.err.println(e.getMessage());
        }
        return null;
    }

    public static void main(String[] args) {
        try {
            new S3MigrateToNewGroups().runFromMain(args);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }
}

