/*
 * Decompiled with CFR 0.152.
 */
package io.continual.shaded.com.rabbitmq.client;

import io.continual.shaded.com.rabbitmq.client.AMQP;
import io.continual.shaded.com.rabbitmq.client.Channel;
import io.continual.shaded.com.rabbitmq.client.RpcServer;
import io.continual.shaded.com.rabbitmq.client.impl.MethodArgumentReader;
import io.continual.shaded.com.rabbitmq.client.impl.MethodArgumentWriter;
import io.continual.shaded.com.rabbitmq.client.impl.ValueReader;
import io.continual.shaded.com.rabbitmq.client.impl.ValueWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class MapRpcServer
extends RpcServer {
    public MapRpcServer(Channel channel) throws IOException {
        super(channel);
    }

    public MapRpcServer(Channel channel, String queueName) throws IOException {
        super(channel, queueName);
    }

    @Override
    public byte[] handleCall(byte[] requestBody, AMQP.BasicProperties replyProperties) {
        try {
            return MapRpcServer.encode(this.handleMapCall(MapRpcServer.decode(requestBody), replyProperties));
        }
        catch (IOException ioe) {
            return new byte[0];
        }
    }

    public static Map<String, Object> decode(byte[] requestBody) throws IOException {
        MethodArgumentReader reader = new MethodArgumentReader(new ValueReader(new DataInputStream(new ByteArrayInputStream(requestBody))));
        Map<String, Object> request = reader.readTable();
        return request;
    }

    public static byte[] encode(Map<String, Object> reply) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        MethodArgumentWriter writer = new MethodArgumentWriter(new ValueWriter(new DataOutputStream(buffer)));
        writer.writeTable(reply);
        writer.flush();
        return buffer.toByteArray();
    }

    public Map<String, Object> handleMapCall(Map<String, Object> request, AMQP.BasicProperties replyProperties) {
        return this.handleMapCall(request);
    }

    public Map<String, Object> handleMapCall(Map<String, Object> request) {
        return new HashMap<String, Object>();
    }

    @Override
    public void handleCast(byte[] requestBody) {
        try {
            this.handleMapCast(MapRpcServer.decode(requestBody));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void handleMapCast(Map<String, Object> requestBody) {
    }
}

