/*
 * Decompiled with CFR 0.152.
 */
package io.continual.metrics.impl;

import io.continual.metrics.DropWizardMetricsService;
import io.continual.metrics.MetricsCatalog;
import io.continual.metrics.metricTypes.Counter;
import io.continual.metrics.metricTypes.Timer;
import io.continual.shaded.com.codahale.metrics.Gauge;
import io.continual.shaded.com.codahale.metrics.Histogram;
import io.continual.shaded.com.codahale.metrics.Meter;
import io.continual.shaded.com.codahale.metrics.MetricRegistry;
import io.continual.shaded.com.codahale.metrics.Timer;
import io.continual.util.data.json.JsonSerialized;
import io.continual.util.naming.Name;
import io.continual.util.naming.Path;
import java.util.LinkedList;
import java.util.Set;
import org.json.JSONObject;

public class StdMetricsCatalog
implements MetricsCatalog,
JsonSerialized {
    private final MetricRegistry fReg;
    private final LinkedList<Path> fPathStack;

    public StdMetricsCatalog(MetricRegistry actualRegistry) {
        this(actualRegistry, Path.getRootPath());
    }

    public StdMetricsCatalog(MetricRegistry actualRegistry, Path basePath) {
        this.fReg = actualRegistry;
        this.fPathStack = new LinkedList();
        this.fPathStack.add(basePath);
    }

    public StdMetricsCatalog getSubCatalog(Name name) {
        return new StdMetricsCatalog(this.fReg, this.getCurrentBase().makeChildItem(this.convertName(name)));
    }

    public StdMetricsCatalog getSubCatalog(String name) {
        return this.getSubCatalog(Name.fromString((String)name));
    }

    public StdMetricsCatalog removeSubCatalog(Name name) {
        String pathPrefix = this.convertPath(this.getCurrentBase().makeChildItem(this.convertName(name))) + ".";
        Set<String> metrics = this.fReg.getMetrics().keySet();
        for (String metric : metrics) {
            if (!metric.startsWith(pathPrefix)) continue;
            this.fReg.remove(metric);
        }
        return this;
    }

    public MetricsCatalog.PathPopper push(String name) {
        Name n = Name.fromString((String)name);
        Path p = this.getCurrentBase().makeChildItem(n);
        this.fPathStack.add(p);
        return new MetricsCatalog.PathPopper(){

            public void close() {
                StdMetricsCatalog.this.pop();
            }
        };
    }

    public void pop() {
        if (this.fPathStack.size() < 2) {
            throw new IllegalStateException("You cannot pop from this metrics catalog.");
        }
        this.fPathStack.removeLast();
    }

    public void remove(String name) {
        Path fullPath = this.getCurrentBase().makeChildPath(Path.getRootPath().makeChildItem(Name.fromString((String)name)));
        String dotted = this.convertPath(fullPath);
        this.fReg.remove(dotted);
    }

    public Counter counter(Path name, String helpText) {
        Path fullPath = this.getCurrentBase().makeChildPath(name);
        final io.continual.shaded.com.codahale.metrics.Counter codaCounter = this.fReg.counter(this.convertPath(fullPath));
        return new Counter(){

            public void increment(long amount) {
                codaCounter.inc(amount);
            }

            public long getCount() {
                return codaCounter.getCount();
            }
        };
    }

    public io.continual.metrics.metricTypes.Meter meter(Path name, String helpText) {
        Path fullPath = this.getCurrentBase().makeChildPath(name);
        final Meter codaMeter = this.fReg.meter(this.convertPath(fullPath));
        return new io.continual.metrics.metricTypes.Meter(){

            public void mark(long amt) {
                codaMeter.mark(amt);
            }

            public long getCount() {
                return codaMeter.getCount();
            }

            public double getMeanRate() {
                return codaMeter.getMeanRate();
            }

            public double getOneMinuteRate() {
                return codaMeter.getOneMinuteRate();
            }

            public double getFiveMinuteRate() {
                return codaMeter.getFiveMinuteRate();
            }

            public double getFifteenMinuteRate() {
                return codaMeter.getFifteenMinuteRate();
            }
        };
    }

    public <T> io.continual.metrics.metricTypes.Gauge<T> gauge(Path name, String helpText, final MetricsCatalog.GaugeFactory<T> factory) {
        Path fullPath = this.getCurrentBase().makeChildPath(name);
        final Gauge codeGauge = this.fReg.gauge(this.convertPath(fullPath), new MetricRegistry.MetricSupplier<Gauge>(){

            @Override
            public Gauge<T> newMetric() {
                final io.continual.metrics.metricTypes.Gauge g = factory.makeNewGauage();
                return new Gauge(){

                    @Override
                    public T getValue() {
                        return g.getValue();
                    }
                };
            }
        });
        return new io.continual.metrics.metricTypes.Gauge<T>(){

            public T getValue() {
                return codeGauge.getValue();
            }
        };
    }

    public io.continual.metrics.metricTypes.Histogram histogram(Path name, String helpText) {
        Path fullPath = this.getCurrentBase().makeChildPath(name);
        final Histogram codaHistogram = this.fReg.histogram(this.convertPath(fullPath));
        return new io.continual.metrics.metricTypes.Histogram(){

            public void update(int value) {
                codaHistogram.update(value);
            }

            public void update(long value) {
                codaHistogram.update(value);
            }
        };
    }

    public io.continual.metrics.metricTypes.Timer timer(Path name, String helpText) {
        Path fullPath = this.getCurrentBase().makeChildPath(name);
        final Timer codaTimer = this.fReg.timer(this.convertPath(fullPath));
        return new io.continual.metrics.metricTypes.Timer(){

            public Timer.Context time() {
                final Timer.Context ctx = codaTimer.time();
                return new Timer.Context(){

                    public long stop() {
                        return ctx.stop();
                    }
                };
            }
        };
    }

    public String toString() {
        return this.toJson().toString();
    }

    public JSONObject toJson() {
        JSONObject metrics = DropWizardMetricsService.toJson(this.fReg);
        for (Name name : this.getCurrentBase().getSegments()) {
            if ((metrics = metrics.optJSONObject(name.toString())) != null) continue;
            return new JSONObject();
        }
        return metrics;
    }

    private String convertPath(Path path) {
        return path.toString().replace('/', '.').substring(1);
    }

    private Name convertName(Name name) {
        return Name.fromString((String)name.toString().replace('.', '_'));
    }

    public Path getBasePath() {
        return this.getCurrentBase();
    }

    private Path getCurrentBase() {
        return this.fPathStack.getLast();
    }

    public static class Builder {
        private MetricRegistry fReg = new MetricRegistry();
        private Path basePath = Path.getRootPath();

        public Builder atBasePath(Path p) {
            this.basePath = p;
            return this;
        }

        public Builder usingRegistry(MetricRegistry reg) {
            this.fReg = reg;
            return this;
        }

        public StdMetricsCatalog build() {
            return new StdMetricsCatalog(this.fReg, this.basePath);
        }
    }
}

