/*
 * Decompiled with CFR 0.152.
 */
package io.continual.http.service.framework.routing.playish;

import io.continual.http.service.framework.routing.playish.CHttpPlayishStaticEntryPointRoutingSource;
import io.continual.resources.ResourceLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CHttpPlayishRoutingFileSource
extends CHttpPlayishStaticEntryPointRoutingSource {
    private static final Logger log = LoggerFactory.getLogger(CHttpPlayishRoutingFileSource.class);

    public CHttpPlayishRoutingFileSource(File f) throws IOException {
        this(f, true);
    }

    public CHttpPlayishRoutingFileSource(File f, boolean withAutoRefresh) throws IOException {
        this.loadRoutes(f);
        this.createRefreshThread(f, withAutoRefresh);
    }

    public CHttpPlayishRoutingFileSource(URL u) throws IOException {
        if (u == null) {
            throw new IOException("URL for routing file is null in CHttpPlayishRoutingFileSource ( URL )");
        }
        this.loadRoutes(u);
    }

    public CHttpPlayishRoutingFileSource(ResourceLoader rl) throws IOException {
        this.loadRoutes(rl);
    }

    private synchronized void loadRoutes(URL u) throws IOException {
        this.loadRoutes(new InputStreamReader(u.openStream()));
    }

    private synchronized void loadRoutes(File f) throws IOException {
        this.loadRoutes(new FileReader(f));
    }

    private synchronized void loadRoutes(ResourceLoader rl) throws IOException {
        InputStream is = rl.load();
        if (is == null) {
            throw new IOException("Unable to load " + rl.toString());
        }
        this.loadRoutes(new InputStreamReader(is));
    }

    private synchronized void loadRoutes(Reader r) throws IOException {
        String line;
        this.clearRoutes();
        BufferedReader fr = new BufferedReader(r);
        while ((line = fr.readLine()) != null) {
            if ((line = line.trim()).length() <= 0 || line.startsWith("#")) continue;
            this.processLine(line);
        }
    }

    private void processLine(String line) {
        try {
            StringTokenizer st = new StringTokenizer(line);
            String verb = st.nextToken();
            if (verb.toLowerCase().equals("package")) {
                String pkg = st.nextToken();
                this.addPackage(pkg);
            } else {
                String path = st.nextToken();
                String action = st.nextToken();
                this.addRoute(verb, path, action);
            }
        }
        catch (NoSuchElementException e) {
            log.warn("There was an error processing route config line: \"" + line + "\"");
        }
        catch (IllegalArgumentException e) {
            log.warn("There was an error processing route config line: \"" + line + "\": " + e.getMessage());
        }
    }

    private Thread createRefreshThread(final File f, boolean routeRefresh) {
        Thread result = null;
        if (routeRefresh) {
            result = new Thread(){
                private long fLastMod;
                {
                    this.fLastMod = f.lastModified();
                }

                @Override
                public void run() {
                    try {
                        1.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    long lastMod = f.lastModified();
                    if (lastMod > this.fLastMod) {
                        log.info("Reloading routes from " + f.getAbsolutePath());
                        try {
                            this.fLastMod = lastMod;
                            CHttpPlayishRoutingFileSource.this.loadRoutes(f);
                        }
                        catch (IOException e) {
                            log.error("Unable to load route file", (Throwable)e);
                        }
                    }
                }
            };
            result.setName("Route file update watcher for " + f.getName() + ".");
            result.setDaemon(true);
            result.start();
        }
        return result;
    }
}

