/*
 * Decompiled with CFR 0.152.
 */
package io.continual.http.service.framework.routing.playish;

import io.continual.http.service.framework.routing.playish.CHttpPlayishRouteHandler;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CHttpPathInfo {
    private final String fVerb;
    private final String fPath;
    private CHttpPlayishRouteHandler fHandler;
    private final Pattern fPathPattern;
    private final List<String> fArgs;

    public CHttpPathInfo(String verb, String path, List<String> args, Pattern pattern) {
        this.fVerb = verb;
        this.fPath = path;
        this.fHandler = null;
        this.fArgs = args;
        this.fPathPattern = pattern;
    }

    public String toString() {
        return this.fVerb + " " + this.fPath + " ==> " + (this.fHandler != null ? this.fHandler.toString() : "(null)");
    }

    public String getVerb() {
        return this.fVerb;
    }

    public String getPath() {
        return this.fPath;
    }

    public void setHandler(CHttpPlayishRouteHandler handler) {
        this.fHandler = handler;
    }

    public CHttpPlayishRouteHandler getHandler() {
        return this.fHandler;
    }

    public String makePath(Map<String, Object> args) {
        StringBuilder result = new StringBuilder();
        if (this.fPath.contains("{")) {
            String remains = this.fPath;
            while (remains.length() > 0) {
                int brace = remains.indexOf(123);
                if (brace > -1) {
                    Object o;
                    int closeBracket;
                    int close = remains.indexOf(125, brace);
                    if (close == -1) {
                        throw new IllegalArgumentException("Opened brace but didn't close it.");
                    }
                    result.append(remains.substring(0, brace));
                    String name = remains.substring(brace + 1, close);
                    if (name.startsWith("<") && (closeBracket = name.indexOf(62)) > -1) {
                        name = name.substring(closeBracket + 1);
                    }
                    Object object = o = args == null ? null : args.get(name);
                    if (o != null) {
                        result.append(args.get(name));
                    } else {
                        result.append("{");
                        result.append(name);
                        result.append("}");
                    }
                    remains = remains.substring(close + 1);
                    continue;
                }
                result.append(remains);
                remains = "";
            }
        } else {
            result.append(this.fPath);
        }
        return result.toString();
    }

    public List<String> getArgs() {
        return new LinkedList<String>(this.fArgs);
    }

    public List<String> matches(String verb, String path) {
        LinkedList<String> result = null;
        if (verb != null && path != null && verb.equalsIgnoreCase(this.fVerb)) {
            Matcher m = this.fPathPattern.matcher(path);
            int argCount = this.fArgs.size();
            if (m.matches()) {
                result = new LinkedList<String>();
                for (int i = 1; i <= argCount; ++i) {
                    String part = m.group(i);
                    String decode = CHttpPathInfo.decode(part);
                    result.add(decode);
                }
            }
        }
        return result;
    }

    public static CHttpPathInfo processPath(String verb, String path) {
        LinkedList<String> args = new LinkedList<String>();
        String fullPathRegex = path;
        if (path.contains("{")) {
            fullPathRegex = "";
            String remains = path;
            while (remains.length() > 0) {
                int brace = remains.indexOf(123);
                if (brace > -1) {
                    String preVar = remains.substring(0, brace);
                    int close = remains.indexOf(125, brace);
                    if (close == -1) {
                        throw new IllegalArgumentException("Opened brace but didn't close it.");
                    }
                    String inner = remains.substring(brace + 1, close);
                    String regex = "([^/]+)";
                    String argName = inner;
                    if (inner.startsWith("<")) {
                        int bracketClose = inner.indexOf(62);
                        if (bracketClose == -1) {
                            throw new IllegalArgumentException("Opened bracket but didn't close it.");
                        }
                        argName = inner.substring(bracketClose + 1);
                        regex = "(" + inner.substring(1, bracketClose) + ")";
                    }
                    args.add(argName);
                    fullPathRegex = fullPathRegex + preVar;
                    fullPathRegex = fullPathRegex + regex;
                    remains = remains.substring(close + 1);
                    continue;
                }
                fullPathRegex = fullPathRegex + remains;
                remains = "";
            }
        }
        Pattern pathPattern = Pattern.compile(fullPathRegex);
        return new CHttpPathInfo(verb, path, args, pathPattern);
    }

    public boolean invokes(String fullName) {
        return this.fHandler.actionMatches(fullName);
    }

    private static String decode(String s) {
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

