/*
 * Decompiled with CFR 0.152.
 */
package io.continual.http.service.framework;

import io.continual.builder.Builder;
import io.continual.http.service.framework.CHttpFilter;
import io.continual.http.service.framework.CHttpRouteInstaller;
import io.continual.http.service.framework.inspection.CHttpObserverMgr;
import io.continual.iam.IamService;
import io.continual.metrics.MetricsCatalog;
import io.continual.metrics.MetricsService;
import io.continual.metrics.impl.noop.NoopMetricsCatalog;
import io.continual.services.Service;
import io.continual.services.ServiceContainer;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class CHttpService
implements Service {
    private final IamService<?, ?> fAccounts;
    private final MetricsCatalog fMetrics;
    private final CHttpObserverMgr fInspector;
    private final LinkedList<CHttpFilter> fFilters;
    private final LinkedList<CHttpRouteInstaller> fRouteInstallers;

    public CHttpService(ServiceContainer sc, JSONObject rawConfig) throws Builder.BuildFailure {
        try {
            JSONObject settings = sc.getExprEval().evaluateJsonObject(rawConfig);
            this.fAccounts = (IamService)sc.getReqdIfNotNull(settings.optString("accountService", null), IamService.class);
            MetricsService ms = (MetricsService)sc.getReqdIfNotNull(settings.optString("metricsService", null), MetricsService.class);
            this.fMetrics = ms == null ? new NoopMetricsCatalog() : ms.getCatalog("http");
            this.fInspector = (CHttpObserverMgr)sc.getReqdIfNotNull(settings.optString("inspector", null), CHttpObserverMgr.class);
            this.fRouteInstallers = new LinkedList();
            this.fFilters = new LinkedList();
        }
        catch (JSONException x) {
            throw new Builder.BuildFailure((Throwable)x);
        }
    }

    @Deprecated
    protected IamService<?, ?> getAccounts() {
        return this.fAccounts;
    }

    @Deprecated
    protected MetricsCatalog getMetrics() {
        return this.fMetrics;
    }

    @Deprecated
    protected CHttpObserverMgr getInspector() {
        return this.fInspector;
    }

    public CHttpService addRouteInstaller(CHttpRouteInstaller routeInstaller) {
        this.fRouteInstallers.add(routeInstaller);
        return this;
    }

    protected List<CHttpRouteInstaller> getRouteInstallers() {
        return Collections.unmodifiableList(this.fRouteInstallers);
    }

    public CHttpService addRequestFilter(CHttpFilter filter) {
        this.fFilters.add(filter);
        return this;
    }

    protected List<CHttpFilter> getFilters() {
        return Collections.unmodifiableList(this.fFilters);
    }
}

