/*
 * Decompiled with CFR 0.152.
 */
package io.continual.http.app.servers.routeInstallers;

import io.continual.builder.Builder;
import io.continual.http.app.servers.CorsOptionsRouter;
import io.continual.http.service.framework.CHttpErrorHandler;
import io.continual.http.service.framework.CHttpRouteInstaller;
import io.continual.http.service.framework.context.CHttpRequestContext;
import io.continual.http.service.framework.routing.CHttpRequestRouter;
import io.continual.http.service.framework.routing.CHttpRouteSource;
import io.continual.http.service.framework.routing.playish.CHttpPlayishInstanceCallRoutingSource;
import io.continual.http.service.framework.routing.playish.CHttpPlayishRoutingFileSource;
import io.continual.resources.ResourceLoader;
import io.continual.util.nv.NvReadable;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import org.json.JSONObject;
import org.slf4j.Logger;

public class BaseRouteInstaller
implements CHttpRouteInstaller {
    private final boolean fWithCors;
    private final LinkedList<CHttpRouteSource> fRouteEntries;
    private final LinkedList<ErrHandlerEntry> fErrorHandlerEntries;

    public BaseRouteInstaller() {
        this(true);
    }

    public BaseRouteInstaller(boolean withCors) {
        this.fWithCors = withCors;
        this.fRouteEntries = new LinkedList();
        this.fErrorHandlerEntries = new LinkedList();
    }

    public BaseRouteInstaller registerRouteSource(CHttpRouteSource routeSource) {
        this.fRouteEntries.add(routeSource);
        return this;
    }

    @Override
    public void setupRouter(CHttpRequestRouter rr, NvReadable prefs) throws IOException {
        if (this.fWithCors) {
            this.setupCorsHandler(rr);
        }
        this.setupExceptionHandlers(rr);
        for (CHttpRouteSource rs : this.fRouteEntries) {
            rr.addRouteSource(rs);
        }
    }

    public BaseRouteInstaller registerRoutes(String routeFile, Object handler) throws Builder.BuildFailure {
        return this.registerRoutes(routeFile, this.getClass(), handler);
    }

    public BaseRouteInstaller registerRoutes(String routeFile, Class<?> clazz, Object handler) throws Builder.BuildFailure {
        try (InputStream is = new ResourceLoader().usingStandardSources(false, clazz).named(routeFile).load();){
            if (is == null) {
                throw new Builder.BuildFailure("Unable to load " + routeFile + ".");
            }
            this.registerRoutes(is, handler);
        }
        catch (IOException x) {
            throw new Builder.BuildFailure((Throwable)x);
        }
        return this;
    }

    public BaseRouteInstaller registerRoutes(InputStream routeFile, Object handler) throws Builder.BuildFailure {
        if (routeFile == null) {
            throw new Builder.BuildFailure("Received a null input stream for routes.");
        }
        try {
            this.registerRouteSource(new CHttpPlayishInstanceCallRoutingSource<Object>(handler, routeFile));
        }
        catch (IOException x) {
            throw new Builder.BuildFailure((Throwable)x);
        }
        return this;
    }

    public BaseRouteInstaller registerStaticRoutes(String routeFile, Class<?> clazz) throws Builder.BuildFailure {
        try {
            this.registerRouteSource(new CHttpPlayishRoutingFileSource(new ResourceLoader().usingStandardSources(false, clazz).named(routeFile)));
        }
        catch (IOException x) {
            throw new Builder.BuildFailure((Throwable)x);
        }
        return this;
    }

    public BaseRouteInstaller registerErrorHandler(Class<? extends Throwable> exClass, CHttpErrorHandler handler) {
        this.fErrorHandlerEntries.add(new ErrHandlerEntry(exClass, handler));
        return this;
    }

    public BaseRouteInstaller registerErrorHandler(Class<? extends Throwable> exClass, int statusCode) {
        return this.registerErrorHandler(exClass, statusCode, null, null);
    }

    public BaseRouteInstaller registerErrorHandler(Class<? extends Throwable> exClass, int statusCode, Logger log) {
        return this.registerErrorHandler(exClass, statusCode, null, log);
    }

    public BaseRouteInstaller registerErrorHandler(Class<? extends Throwable> exClass, int statusCode, String configuredMsg) {
        return this.registerErrorHandler(exClass, statusCode, configuredMsg, null);
    }

    public BaseRouteInstaller registerErrorHandler(Class<? extends Throwable> exClass, final int statusCode, final String configuredMsg, final Logger log) {
        return this.registerErrorHandler(exClass, new CHttpErrorHandler(){

            @Override
            public void handle(CHttpRequestContext ctx, Throwable cause) {
                String actualMsg = configuredMsg == null ? cause.getMessage() : configuredMsg;
                ctx.response().sendStatusAndBody(statusCode, new JSONObject().put("error", statusCode).put("message", (Object)actualMsg).toString(), "application/json");
                if (log != null) {
                    log.warn(actualMsg, cause);
                }
            }
        });
    }

    protected void setupCorsHandler(CHttpRequestRouter rr) {
        rr.addRouteSource(new CorsOptionsRouter());
    }

    protected void setupExceptionHandlers(CHttpRequestRouter rr) {
        for (ErrHandlerEntry ehe : this.fErrorHandlerEntries) {
            rr.setHandlerForException(ehe.getExceptionClass(), ehe.getHandler());
        }
    }

    private class ErrHandlerEntry {
        private final Class<? extends Throwable> fEx;
        private final CHttpErrorHandler fHandler;

        public ErrHandlerEntry(Class<? extends Throwable> exClass, CHttpErrorHandler handler) {
            this.fEx = exClass;
            this.fHandler = handler;
        }

        public Class<? extends Throwable> getExceptionClass() {
            return this.fEx;
        }

        public CHttpErrorHandler getHandler() {
            return this.fHandler;
        }
    }
}

