/*
 * Decompiled with CFR 0.152.
 */
package io.continual.http.app.servers.endpoints;

import io.continual.http.service.framework.context.CHttpRequestContext;
import io.continual.util.data.TypeConvertor;
import io.continual.util.data.json.CommentedJsonTokener;
import io.continual.util.data.json.JsonUtil;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JsonIoEndpoint {
    private static final String kStatusCode = "statusCode";

    protected static JSONObject readBody(CHttpRequestContext context) throws JSONException, IOException {
        return new JSONObject((JSONTokener)new CommentedJsonTokener(context.request().getBodyStream()));
    }

    protected static String readJsonString(JSONObject from, String label) throws MissingInputException {
        try {
            return from.getString(label);
        }
        catch (JSONException x) {
            throw new MissingInputException("Missing required field '" + label + "' in input.");
        }
    }

    protected static JSONObject readJsonObject(JSONObject from, String label) throws MissingInputException {
        try {
            return from.getJSONObject(label);
        }
        catch (JSONException x) {
            throw new MissingInputException("Missing required field '" + label + "' in input.");
        }
    }

    protected static void sendJson(CHttpRequestContext context, int statusCode, JSONObject payload) {
        boolean pretty = TypeConvertor.convertToBooleanBroad((String)context.request().getFirstHeader("X-CioPrettyJson"));
        context.response().sendStatusAndBody(statusCode, pretty ? payload.toString(4) : payload.toString(), "application/json");
    }

    protected static void sendJson(CHttpRequestContext context, JSONObject payload) {
        JsonIoEndpoint.sendJson(context, 200, payload);
    }

    protected static void sendStatusCodeAndMessage(CHttpRequestContext context, int statusCode, String msg) {
        JsonIoEndpoint.sendJson(context, statusCode, new JSONObject().put(kStatusCode, statusCode).put("message", (Object)msg));
    }

    protected static void sendStatusOk(CHttpRequestContext context, String msg) {
        JsonIoEndpoint.sendStatusCodeAndMessage(context, 200, msg);
    }

    protected static void sendStatusOk(CHttpRequestContext context, JSONObject msg) {
        JsonIoEndpoint.sendJson(context, 200, JsonUtil.clone((JSONObject)msg).put(kStatusCode, 200));
    }

    protected static void sendStatusOkNoContent(CHttpRequestContext context) {
        context.response().setStatus(204);
    }

    protected static void sendNotAuth(CHttpRequestContext context) {
        JsonIoEndpoint.sendStatusCodeAndMessage(context, 401, "Unauthorized. Check your API credentials.");
    }

    public static class MissingInputException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public MissingInputException(String msg) {
            super(msg);
        }
    }
}

