/*
 * Decompiled with CFR 0.152.
 */
package io.continual.http.app.htmlForms;

import io.continual.http.app.htmlForms.mime.CHttpMimePart;
import io.continual.http.app.htmlForms.mime.CHttpMimePartFactory;
import io.continual.http.app.htmlForms.mime.CHttpMimePartsReader;
import io.continual.http.service.framework.context.CHttpRequest;
import io.continual.util.collections.MultiMap;
import io.continual.util.data.TypeConvertor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CHttpFormPostWrapper {
    private final CHttpRequest fRequest;
    private final boolean fIsMultipartFormData;
    private boolean fParseComplete;
    private final HashMap<String, CHttpMimePart> fParsedValues;
    private final CHttpMimePartFactory fPartFactory;
    private static final String kBoundaryTag = "boundary=";
    static final Logger log = LoggerFactory.getLogger(CHttpFormPostWrapper.class);

    public CHttpFormPostWrapper(CHttpRequest req) {
        this(req, null);
    }

    public CHttpFormPostWrapper(CHttpRequest req, CHttpMimePartFactory mimePartFactory) {
        this.fRequest = req;
        String ct = req.getContentType();
        this.fIsMultipartFormData = ct != null && ct.startsWith("multipart/form-data");
        this.fPartFactory = mimePartFactory == null ? new simpleStorage() : mimePartFactory;
        this.fParsedValues = new HashMap();
        this.fParseComplete = false;
    }

    public void close() {
        for (CHttpMimePart vi : this.fParsedValues.values()) {
            vi.discard();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.fRequest.getMethod().toUpperCase()).append(" {");
        if (this.fIsMultipartFormData) {
            if (this.fParseComplete) {
                for (Map.Entry<String, CHttpMimePart> e : this.fParsedValues.entrySet()) {
                    sb.append(e.getKey()).append(":");
                    CHttpMimePart mp = e.getValue();
                    if (mp.getAsString() != null) {
                        sb.append("'").append(mp.getAsString()).append("' ");
                        continue;
                    }
                    sb.append("(data) ");
                }
            } else {
                sb.append("not parsed yet");
            }
        } else {
            for (Map.Entry<String, String[]> e : this.fRequest.getParameterMap().entrySet()) {
                StringBuilder sb2 = new StringBuilder();
                for (String val : e.getValue()) {
                    if (sb2.length() > 0) {
                        sb2.append(",");
                    }
                    sb2.append(val);
                }
                sb.append(e.getKey()).append(": [").append(sb2.toString()).append("], ");
            }
        }
        sb.append(" }");
        return sb.toString();
    }

    public boolean isPost() {
        return this.fRequest.getMethod().toLowerCase().equals("POST");
    }

    public boolean hasParameter(String name) throws ParseException {
        this.parseIfNeeded();
        return this.fIsMultipartFormData ? this.fParsedValues.containsKey(name) : this.fRequest.getParameterMap().containsKey(name);
    }

    public Set<String> getKeys() throws ParseException {
        TreeSet<String> set = new TreeSet<String>();
        this.parseIfNeeded();
        if (this.fIsMultipartFormData) {
            set.addAll(this.fParsedValues.keySet());
        } else {
            set.addAll(this.fRequest.getParameterMap().keySet());
        }
        return set;
    }

    public Map<String, String> getValues() throws ParseException {
        HashMap<String, String> map = new HashMap<String, String>();
        this.parseIfNeeded();
        if (this.fIsMultipartFormData) {
            for (Map.Entry<String, CHttpMimePart> e : this.fParsedValues.entrySet()) {
                String val = e.getValue().getAsString();
                if (val == null) continue;
                map.put(e.getKey(), val);
            }
        } else {
            for (Map.Entry<String, String[]> e : this.fRequest.getParameterMap().entrySet()) {
                String key = e.getKey().toString();
                String[] vals = e.getValue();
                String valToUse = "";
                if (vals.length > 0) {
                    valToUse = vals[0];
                }
                map.put(key, valToUse);
            }
        }
        return map;
    }

    public boolean isFormField(String name) throws ParseException {
        boolean result = false;
        if (this.hasParameter(name)) {
            CHttpMimePart val;
            result = this.fIsMultipartFormData ? (val = this.fParsedValues.get(name)) != null && val.getAsString() != null : true;
        }
        return result;
    }

    public String getValue(String name) throws ParseException {
        String result;
        this.parseIfNeeded();
        if (this.fIsMultipartFormData) {
            CHttpMimePart val = this.fParsedValues.get(name);
            result = null;
            if (val != null && val.getAsString() != null) {
                result = val.getAsString().trim();
            }
        } else {
            result = this.fRequest.getParameter(name);
            if (result != null) {
                result = result.trim();
            }
        }
        return result;
    }

    public String getValue(Object o) throws ParseException {
        return this.getValue(o.toString());
    }

    public String getValue(String key, String defVal) throws ParseException {
        String result = this.getValue(key);
        if (result == null) {
            result = defVal;
        }
        return result;
    }

    public String getValue(Object fieldName, String defVal) throws ParseException {
        return this.getValue(fieldName.toString(), defVal);
    }

    public boolean getValueBoolean(String name, boolean valIfMissing) throws ParseException {
        boolean result = valIfMissing;
        String val = this.getValue(name);
        if (val != null) {
            result = TypeConvertor.convertToBooleanBroad((String)val);
        }
        return result;
    }

    public boolean getValueBoolean(Object fieldName, boolean valIfMissing) throws ParseException {
        return this.getValueBoolean(fieldName.toString(), valIfMissing);
    }

    public Integer getValueInt(String name) throws ParseException {
        return this.getValueInt(name, null);
    }

    public Integer getValueInt(String name, Integer valIfMissing) throws ParseException {
        Integer result = valIfMissing;
        String val = this.getValue(name);
        if (val != null) {
            try {
                result = TypeConvertor.convertToInt((String)val);
            }
            catch (TypeConvertor.conversionError e) {
                result = valIfMissing;
            }
        }
        return result;
    }

    public Integer getValueInt(Object fieldName, Integer valIfMissing) throws ParseException {
        return this.getValueInt(fieldName.toString(), valIfMissing);
    }

    public Double getValueDouble(String name) throws ParseException {
        return this.getValueDouble(name, null);
    }

    public Double getValueDouble(String name, Double valIfMissing) throws ParseException {
        Double result = valIfMissing;
        String val = this.getValue(name);
        if (val != null) {
            try {
                result = TypeConvertor.convertToDouble((String)val);
            }
            catch (TypeConvertor.conversionError e) {
                result = valIfMissing;
            }
        }
        return result;
    }

    public Double getValueDouble(Object fieldName, Double valIfMissing) throws ParseException {
        return this.getValueDouble(fieldName.toString(), valIfMissing);
    }

    public void changeValue(String fieldName, String newVal) throws ParseException {
        this.parseIfNeeded();
        if (this.fIsMultipartFormData) {
            if (this.fParsedValues.containsKey(fieldName)) {
                this.fParsedValues.get(fieldName).discard();
            }
            inMemoryFormDataPart part = new inMemoryFormDataPart("", "form-data; name=\"" + fieldName + "\"");
            byte[] array = newVal.getBytes();
            part.write(array, 0, array.length);
            part.close();
            this.fParsedValues.put(fieldName, part);
        } else {
            this.fRequest.changeParameter(fieldName, newVal);
        }
    }

    public CHttpMimePart getStream(String name) throws ParseException {
        CHttpMimePart val;
        this.parseIfNeeded();
        if (this.fIsMultipartFormData && (val = this.fParsedValues.get(name)) != null && val.getAsString() == null) {
            return val;
        }
        return null;
    }

    private void parseIfNeeded() throws ParseException {
        if (this.fIsMultipartFormData && !this.fParseComplete) {
            try {
                String ct = this.fRequest.getContentType();
                int boundaryStartIndex = ct.indexOf(kBoundaryTag);
                if (boundaryStartIndex != -1) {
                    int semi = ct.indexOf(";", boundaryStartIndex += kBoundaryTag.length());
                    int boundaryEndIndex = semi == -1 ? ct.length() : semi;
                    String boundary = ct.substring(boundaryStartIndex, boundaryEndIndex).trim();
                    CHttpMimePartsReader mmr = new CHttpMimePartsReader(boundary, this.fPartFactory);
                    InputStream is = this.fRequest.getBodyStream();
                    mmr.read(is);
                    is.close();
                    for (CHttpMimePart mp : mmr.getParts()) {
                        this.fParsedValues.put(mp.getName(), mp);
                    }
                }
            }
            catch (IOException e) {
                log.warn("There was a problem reading a multipart/form-data POST: " + e.getMessage());
                throw new ParseException(e);
            }
            this.fParseComplete = true;
        }
    }

    static class simpleStorage
    implements CHttpMimePartFactory {
        simpleStorage() {
        }

        @Override
        public CHttpMimePart createPart(MultiMap<String, String> partHeaders) throws IOException {
            String contentDisp = (String)partHeaders.getFirst((Object)"content-disposition");
            if (contentDisp != null && contentDisp.contains("filename=\"")) {
                return new tmpFilePart((String)partHeaders.getFirst((Object)"content-type"), contentDisp);
            }
            return new inMemoryFormDataPart((String)partHeaders.getFirst((Object)"content-type"), contentDisp);
        }
    }

    private static class tmpFilePart
    extends basePart {
        private File fFile = File.createTempFile("chttp.", ".part");
        private FileOutputStream fStream = new FileOutputStream(this.fFile);

        public tmpFilePart(String ct, String cd) throws IOException {
            super(ct, cd);
        }

        @Override
        public void write(byte[] line, int offset, int length) throws IOException {
            if (this.fStream != null) {
                this.fStream.write(line, offset, length);
            }
        }

        @Override
        public void close() throws IOException {
            if (this.fStream != null) {
                this.fStream.close();
                this.fStream = null;
            }
        }

        @Override
        public InputStream openStream() throws IOException {
            if (this.fStream != null) {
                log.warn("Opening input stream on tmp file before it's fully written.");
            }
            return new FileInputStream(this.fFile);
        }

        @Override
        public String getAsString() {
            return null;
        }

        @Override
        public void discard() {
            this.fFile.delete();
            this.fFile = null;
            this.fStream = null;
        }
    }

    public static class inMemoryFormDataPart
    extends basePart {
        private String fValue = "";

        public inMemoryFormDataPart(String ct, String cd) {
            super(ct, cd);
        }

        @Override
        public void write(byte[] line, int offset, int length) {
            this.fValue = new String(line, offset, length);
        }

        @Override
        public void close() {
        }

        @Override
        public InputStream openStream() throws IOException {
            throw new IOException("Opening stream on in-memory form data.");
        }

        @Override
        public String getAsString() {
            return this.fValue;
        }
    }

    public static abstract class basePart
    implements CHttpMimePart {
        private final String fType;
        private final String fDisp;
        private final String fName;
        private final HashMap<String, String> fDispMap;

        public basePart(String contentType, String contentDisp) {
            this.fType = contentType;
            this.fDisp = contentDisp;
            this.fDispMap = new HashMap();
            this.parseDisposition(contentDisp);
            int nameSpot = this.fDisp.indexOf("name=\"");
            String namePart = this.fDisp.substring(nameSpot + "name=\"".length());
            int closeQuote = namePart.indexOf("\"");
            this.fName = namePart = namePart.substring(0, closeQuote);
        }

        @Override
        public String getContentType() {
            return this.fType;
        }

        @Override
        public String getContentDisposition() {
            return this.fDisp;
        }

        @Override
        public String getContentDispositionValue(String key) {
            return this.fDispMap.get(key);
        }

        @Override
        public String getName() {
            return this.fName;
        }

        @Override
        public void discard() {
        }

        private void parseDisposition(String contentDisp) {
            String[] parts;
            for (String part : parts = contentDisp.split(";")) {
                String key = part.trim();
                String val = "";
                int eq = key.indexOf(61);
                if (eq > -1) {
                    val = key.substring(eq + 1);
                    key = key.substring(0, eq);
                    if (val.startsWith("\"") && val.endsWith("\"")) {
                        val = val.substring(1, val.length() - 1);
                    }
                }
                this.fDispMap.put(key, val);
            }
        }
    }

    public static class ParseException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ParseException(Throwable t) {
            super(t);
        }
    }
}

