/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.engine.library.processors;

import io.continual.builder.Builder;
import io.continual.services.processor.config.readers.ConfigLoadContext;
import io.continual.services.processor.engine.model.MessageProcessingContext;
import io.continual.services.processor.engine.model.Processor;
import io.continual.util.data.json.JsonUtil;
import java.util.TreeSet;
import org.json.JSONException;
import org.json.JSONObject;

public class ShiftDown
implements Processor {
    private final String fFieldExpr;

    public ShiftDown(String fieldExpr) {
        this.fFieldExpr = fieldExpr;
    }

    public ShiftDown(ConfigLoadContext sc, JSONObject config) throws Builder.BuildFailure {
        try {
            this.fFieldExpr = config.getString("to");
        }
        catch (JSONException e) {
            throw new Builder.BuildFailure((Throwable)e);
        }
    }

    @Override
    public void process(MessageProcessingContext context) {
        String field = context.evalExpression(this.fFieldExpr);
        JSONObject msgJson = context.getMessage().accessRawJson();
        JSONObject replacement = msgJson.optJSONObject(field);
        if (replacement == null) {
            context.warn("Evaluation of [" + this.fFieldExpr + "] did not result in an object.");
            return;
        }
        TreeSet keys = new TreeSet(msgJson.keySet());
        for (String key : keys) {
            msgJson.remove(key);
        }
        JsonUtil.copyInto((JSONObject)replacement, (JSONObject)msgJson);
    }
}

