/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.engine.library.processors;

import io.continual.builder.Builder;
import io.continual.notify.ContinualNotifier;
import io.continual.services.processor.config.readers.ConfigLoadContext;
import io.continual.services.processor.engine.model.MessageProcessingContext;
import io.continual.services.processor.engine.model.Processor;
import io.continual.util.data.exprEval.ExprDataSource;
import io.continual.util.data.exprEval.ExpressionEvaluator;
import io.continual.util.data.exprEval.JsonDataSource;
import io.continual.util.data.json.JsonUtil;
import org.json.JSONObject;

public class Notify
implements Processor {
    private final JSONObject fPreConfig;
    private static final String kTopicSetting = "CONTINUAL_TOPIC";
    private static final String kStreamSetting = "CONTINUAL_STREAM";
    private static final String kMsgSetting = "CONTINUAL_MESSAGE";
    private static final String kUserSetting = "CONTINUAL_USER";
    private static final String kPasswordSetting = "CONTINUAL_PASSWORD";

    public Notify() throws Builder.BuildFailure {
        this.fPreConfig = new JSONObject();
    }

    public Notify(JSONObject config) throws Builder.BuildFailure {
        this.fPreConfig = JsonUtil.clone((JSONObject)config);
    }

    public Notify(ConfigLoadContext sc, JSONObject config) throws Builder.BuildFailure {
        ExpressionEvaluator ee = sc.getServiceContainer().getExprEval();
        this.fPreConfig = new JSONObject().put(kTopicSetting, ee.evaluateSymbol(kTopicSetting)).put(kStreamSetting, ee.evaluateSymbol(kStreamSetting)).put(kMsgSetting, ee.evaluateSymbol(kMsgSetting)).put(kUserSetting, ee.evaluateSymbol(kUserSetting)).put(kPasswordSetting, ee.evaluateSymbol(kPasswordSetting));
    }

    @Override
    public void process(MessageProcessingContext context) {
        String msgEval = this.readSetting(context, kMsgSetting);
        String line = msgEval == null ? context.getMessage().toLine() : context.evalExpression(msgEval);
        new ContinualNotifier().asUser(this.readSetting(context, kUserSetting), this.readSetting(context, kPasswordSetting)).toTopic(this.readSetting(context, kTopicSetting)).onStream(this.readSetting(context, kStreamSetting)).withDetails(line).send();
    }

    private String readSetting(MessageProcessingContext context, String key) {
        String result = context.evalExpression("${" + key + "}", new ExprDataSource[]{new JsonDataSource(this.fPreConfig)});
        return result == null || result.length() == 0 ? null : result;
    }
}

