/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.engine.library.processors;

import io.continual.builder.Builder;
import io.continual.services.processor.config.readers.ConfigLoadContext;
import io.continual.services.processor.config.readers.ConfigReadException;
import io.continual.services.processor.config.readers.JsonConfigReader;
import io.continual.services.processor.engine.model.MessageProcessingContext;
import io.continual.services.processor.engine.model.Pipeline;
import io.continual.services.processor.engine.model.Processor;
import io.continual.util.data.json.JsonEval;
import io.continual.util.data.json.JsonVisitor;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ForEachObject
implements Processor {
    private final String fSet;
    private final Pipeline fPipeline;
    private final String fVarName;

    public ForEachObject(ConfigLoadContext clc, JSONObject config) throws Builder.BuildFailure {
        try {
            this.fSet = config.getString("set");
            this.fPipeline = JsonConfigReader.readPipeline(config.optJSONArray("processing"), new ArrayList<String>(), clc);
            this.fVarName = config.optString("varName", "_item");
        }
        catch (ConfigReadException | JSONException e) {
            throw new Builder.BuildFailure(e);
        }
    }

    @Override
    public void process(final MessageProcessingContext context) {
        JSONObject data = context.getMessage().accessRawJson();
        Object setData = JsonEval.eval((JSONObject)data, (String)this.fSet);
        if (setData instanceof JSONArray) {
            JsonVisitor.forEachElement((JSONArray)((JSONArray)setData), (JsonVisitor.ArrayVisitor)new JsonVisitor.ArrayVisitor<JSONObject, JSONException>(){

                public boolean visit(JSONObject itemElement) throws JSONException {
                    Object valWas = context.getMessage().getRawValue(ForEachObject.this.fVarName);
                    context.getMessage().putRawValue(ForEachObject.this.fVarName, itemElement);
                    ForEachObject.this.fPipeline.process(context);
                    context.getMessage().clearValue(ForEachObject.this.fVarName).putRawValue(ForEachObject.this.fVarName, valWas);
                    return true;
                }
            });
        } else if (setData instanceof JSONObject) {
            JsonVisitor.forEachElement((JSONObject)((JSONObject)setData), (JsonVisitor.ObjectVisitor)new JsonVisitor.ObjectVisitor<Object, JSONException>(){

                public boolean visit(String key, Object itemElement) throws JSONException {
                    if (itemElement instanceof JSONObject || itemElement instanceof String) {
                        context.getMessage().putRawValue("_key", key).putRawValue("_item", itemElement);
                        ForEachObject.this.fPipeline.process(context);
                        context.getMessage().clearValue("_key").clearValue("_item");
                    }
                    return true;
                }
            });
        }
    }
}

