/*
 * Decompiled with CFR 0.152.
 */
package io.continual.templating.impl.simpleDoubleBrace;

import io.continual.services.ServiceContainer;
import io.continual.services.SimpleService;
import io.continual.templating.ContinualTemplateContext;
import io.continual.templating.ContinualTemplateEngine;
import io.continual.templating.ContinualTemplateSource;
import io.continual.templating.impl.BasicContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.json.JSONObject;

public class SimpleDoubleBraceTemplateEngine
extends SimpleService
implements ContinualTemplateEngine {
    private static final int kMaxReadLen = 32;

    public SimpleDoubleBraceTemplateEngine(ServiceContainer sc, JSONObject config) {
    }

    @Override
    public ContinualTemplateContext createContext() {
        return new BasicContext();
    }

    @Override
    public void renderTemplate(ContinualTemplateSource templateSrc, ContinualTemplateContext context, OutputStream outTo) throws ContinualTemplateSource.TemplateNotFoundException, IOException {
        String chunk;
        InputStream is = templateSrc.getTemplate();
        StringBuilder token = null;
        while (null != (chunk = this.readChunk(is))) {
            if (token == null && chunk.equals("{{")) {
                token = new StringBuilder();
                continue;
            }
            if (token != null) {
                if (chunk.equals("}}")) {
                    String key = token.toString().trim();
                    token = null;
                    Object val = context.get(key);
                    if (val == null) {
                        val = "";
                    }
                    outTo.write(val.toString().getBytes(StandardCharsets.UTF_8));
                    continue;
                }
                token.append(chunk);
                continue;
            }
            outTo.write(chunk.getBytes(StandardCharsets.UTF_8));
        }
        if (token != null) {
            outTo.write("{{".getBytes(StandardCharsets.UTF_8));
            outTo.write(token.toString().getBytes(StandardCharsets.UTF_8));
        }
        outTo.flush();
    }

    String readChunk(InputStream is) throws IOException {
        StringBuilder sb = new StringBuilder();
        while (sb.length() < 32) {
            is.mark(2);
            int c = is.read();
            if (c == 123) {
                if (sb.length() == 0) {
                    sb.append("{");
                    continue;
                }
                if (sb.length() == 1 && sb.charAt(0) == '{') {
                    return "{{";
                }
                is.reset();
                return sb.toString();
            }
            if (c == 125) {
                if (sb.length() == 0) {
                    sb.append("}");
                    continue;
                }
                if (sb.length() == 1 && sb.charAt(0) == '}') {
                    return "}}";
                }
                is.reset();
                return sb.toString();
            }
            if (c == -1) {
                return sb.length() > 0 ? sb.toString() : null;
            }
            sb.append((char)c);
        }
        return sb.toString();
    }
}

