/*
 * Decompiled with CFR 0.152.
 */
package io.continual.http.service.framework.sessions;

import io.continual.http.service.framework.CHttpSession;
import io.continual.http.service.framework.context.CHttpRequestContext;
import io.continual.iam.IamService;
import io.continual.iam.credentials.UsernamePasswordCredential;
import io.continual.iam.exceptions.IamSvcException;
import io.continual.iam.identity.Identity;
import io.continual.iam.identity.UserContext;
import io.continual.templating.ContinualTemplateContext;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CHttpUserSession
implements CHttpSession {
    private final IamService<?, ?> fAccounts;
    private UserContext<?> fUser;
    private HashMap<String, String> fSessionData;
    private static final Logger log = LoggerFactory.getLogger(CHttpUserSession.class);

    public static CHttpUserSession getSession(CHttpRequestContext context) {
        CHttpSession dc = context.session();
        if (dc instanceof CHttpUserSession) {
            return (CHttpUserSession)dc;
        }
        throw new IllegalArgumentException(dc == null ? "No user session established." : "User session is not an HttpUserSession");
    }

    public CHttpUserSession(IamService<?, ?> accounts) {
        this.fAccounts = accounts;
        this.fUser = null;
        this.fSessionData = new HashMap();
    }

    public CHttpUserSession put(String key, String val) {
        this.fSessionData.put(key, val);
        return this;
    }

    public CHttpUserSession remove(String key) {
        this.fSessionData.remove(key);
        return this;
    }

    public void populateTemplateContext(ContinualTemplateContext templateCtx) {
        templateCtx.putAll(this.fSessionData);
    }

    public void login(String username, String password) {
        if (this.isLoggedIn()) {
            this.logout();
        }
        try {
            Identity user;
            Identity identity = user = this.fAccounts != null ? this.fAccounts.getIdentityDb().authenticate(new UsernamePasswordCredential(username, password)) : null;
            if (user != null) {
                log.info("LOGIN_OK [" + user.getId() + "].");
                this.fUser = new UserContext.Builder().forUser(user).build();
            } else {
                log.info("LOGIN_FAIL [" + username + "]");
            }
        }
        catch (IamSvcException e) {
            log.warn("Couldn't login user [" + username + "]: " + e.getMessage(), (Throwable)e);
        }
    }

    public void logout() {
        if (this.fUser != null) {
            log.info("Logout [" + this.fUser.toString() + "].");
        }
        this.fUser = null;
    }

    public void replaceLoggedInUser(Identity user) {
        if (this.isLoggedIn()) {
            this.logout();
        }
        log.info("LOGIN_REPLACED [" + user.getId() + "].");
        this.fUser = new UserContext.Builder().forUser(user).build();
    }

    public boolean isLoggedIn() {
        return this.fUser != null;
    }

    public UserContext<?> getUser() {
        return this.fUser;
    }

    @Override
    public ByteArrayInputStream serialize() {
        return new ByteArrayInputStream(new JSONObject().put("user", this.fUser != null ? this.fUser.toJson() : null).toString().getBytes());
    }

    @Override
    public void deserialize(ByteArrayInputStream sessionData) {
        this.fUser = null;
    }
}

