/*
 * Decompiled with CFR 0.152.
 */
package io.continual.http.service.framework.routing.staticPaths;

import io.continual.http.service.framework.context.CHttpRequestContext;
import io.continual.http.service.framework.routing.CHttpRouteInvocation;
import io.continual.http.service.framework.routing.CHttpRouteSource;
import io.continual.http.service.framework.routing.playish.StaticDirHandler;
import io.continual.util.data.StreamTools;
import io.continual.util.naming.Name;
import io.continual.util.naming.Path;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CHttpStaticPathRouter
implements CHttpRouteSource {
    public static String kMaxAge = "chttp.staticFile.cache.maxAgeSeconds";
    private static final Logger log = LoggerFactory.getLogger(CHttpStaticPathRouter.class);
    private final File fBaseDir;
    private final int fCacheMaxAge;

    public CHttpStaticPathRouter(File baseDir, int cacheMaxAge) throws IOException {
        this.fBaseDir = baseDir.getCanonicalFile();
        if (!this.fBaseDir.exists() || !this.fBaseDir.isDirectory()) {
            throw new IllegalArgumentException(baseDir + " is not a directory.");
        }
        this.fCacheMaxAge = cacheMaxAge;
    }

    @Override
    public synchronized CHttpRouteInvocation getRouteFor(final String verb, final String path) {
        if (!verb.equalsIgnoreCase("GET") && !verb.equalsIgnoreCase("HEAD")) {
            return null;
        }
        final File toServe = new File(this.fBaseDir, path);
        return new CHttpRouteInvocation(){

            @Override
            public void run(CHttpRequestContext context) throws IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                File canonical;
                File in = toServe;
                if (in.isDirectory()) {
                    in = new File(in, "index.html");
                }
                if (!(canonical = in.getCanonicalFile()).getAbsolutePath().startsWith(CHttpStaticPathRouter.this.fBaseDir.getAbsolutePath())) {
                    log.debug("ignoring [" + path + "] because it is outside of the base directory.");
                    log.warn("404 [" + path + "]==>[" + path + "] (" + in.getAbsolutePath() + ")");
                    context.response().sendError(404, path + " was not found on this server.");
                    return;
                }
                if (CHttpStaticPathRouter.this.fCacheMaxAge > 0) {
                    context.response().writeHeader("Cache-Control", "max-age=" + CHttpStaticPathRouter.this.fCacheMaxAge, true);
                }
                String contentType = StaticDirHandler.mapToContentType(in.getName());
                try {
                    FileInputStream is = new FileInputStream(in);
                    OutputStream os = context.response().getStreamForBinaryResponse(contentType);
                    StreamTools.copyStream((InputStream)is, (OutputStream)os);
                }
                catch (FileNotFoundException e) {
                    log.warn("404 [" + path + "]==>[" + path + "] (" + in.getAbsolutePath() + ")");
                    context.response().sendError(404, path + " was not found on this server.");
                }
                catch (IOException e) {
                    log.warn("500 [" + toServe.getAbsolutePath() + "]: " + e.getMessage());
                    context.response().sendError(500, e.getMessage());
                }
            }

            @Override
            public Path getRouteNameForMetrics() {
                return Path.getRootPath().makeChildItem(Name.fromString((String)verb)).makeChildItem(Name.fromString((String)path.replaceAll("\\.", "%2E").replaceAll("/", "%2F")));
            }
        };
    }

    @Override
    public String getRouteTo(Class<?> c, String staticMethodName, Map<String, Object> args) {
        return null;
    }
}

