/*
 * Decompiled with CFR 0.152.
 */
package io.continual.http.app.servers.endpoints;

import io.continual.builder.Builder;
import io.continual.http.app.servers.CorsOptionsRouter;
import io.continual.http.app.servers.endpoints.AuthList;
import io.continual.http.app.servers.endpoints.JsonIoEndpoint;
import io.continual.http.service.framework.context.CHttpRequestContext;
import io.continual.iam.IamService;
import io.continual.iam.access.AccessDb;
import io.continual.iam.access.Resource;
import io.continual.iam.exceptions.IamSvcException;
import io.continual.iam.identity.Identity;
import io.continual.iam.identity.UserContext;
import io.continual.services.ServiceContainer;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypicalRestApiEndpoint<I extends Identity>
extends JsonIoEndpoint {
    public static final String kSetting_ContinualProductTag = "apiKeyProductTag";
    public static final String kContinualProductTag = "continual";
    public static final String kContinualSystemsGroup = "continualSystems";
    public static final String kSetting_AuthLineHeader = "http.auth.header";
    public static final String kSetting_DateLineHeader = "http.date.header";
    public static final String kSetting_MagicLineHeader = "http.magic.header";
    public static final String kDefault_AuthLineHeader = "X-Continual-Auth";
    public static final String kDefault_DateLineHeader = "X-Continual-Date";
    public static final String kDefault_MagicLineHeader = "X-Continual-Magic";
    private final IamService<I, ?> fAccts;
    private final Authenticator<I> fAuthenticator;
    private static final Logger log = LoggerFactory.getLogger(TypicalRestApiEndpoint.class);
    private static String[] kAcctSvcKeys = new String[]{"accounts", "accountsService"};

    public static Resource makeResource(String named) {
        return Resource.fromName((String)named);
    }

    public TypicalRestApiEndpoint(ServiceContainer sc, JSONObject settings) throws Builder.BuildFailure {
        this.fAccts = (IamService)sc.getReqd(TypicalRestApiEndpoint.getAcctsSvcName(settings), IamService.class);
        this.fAuthenticator = new AuthList(settings);
    }

    public void handleWithApiAuth(CHttpRequestContext context, ApiHandler<I> handler) {
        this.handleWithApiAuthAndAccess(context, handler, new ResourceAccess[0]);
    }

    public void handleWithApiAuthAndAccess(CHttpRequestContext context, ApiHandler<I> handler, ResourceAccess ... accessReqd) {
        try {
            CorsOptionsRouter.setupCorsHeaders(context);
            UserContext<I> user = this.getUser(context);
            if (user == null) {
                TypicalRestApiEndpoint.sendNotAuth(context);
                return;
            }
            String uid = user.getEffectiveUserId();
            AccessDb adb = this.fAccts.getAccessDb();
            for (ResourceAccess ra : accessReqd) {
                if (adb.canUser(uid, ra.fResource, ra.fOp)) continue;
                TypicalRestApiEndpoint.sendNotAuth(context);
                return;
            }
            handler.handle(context, user);
        }
        catch (IOException e) {
            log.warn(e.getMessage());
            TypicalRestApiEndpoint.sendStatusCodeAndMessage(context, 500, "I/O problem writing the response, but... you got it???");
        }
        catch (IamSvcException | JSONException e) {
            log.warn(e.getMessage(), e);
            TypicalRestApiEndpoint.sendStatusCodeAndMessage(context, 500, "There was a problem handling your API request.");
        }
    }

    public boolean canUser(CHttpRequestContext context, UserContext<Identity> user, String resId, String operation) throws IamSvcException {
        boolean result = this.fAccts.getAccessDb().canUser(user.getEffectiveUserId(), TypicalRestApiEndpoint.makeResource(resId), operation);
        if (!result) {
            log.info(user.toString() + " cannot " + operation + " object " + resId);
        }
        return result;
    }

    public UserContext<I> getUser(CHttpRequestContext context) throws IamSvcException {
        IamService<I, ?> am = this.fAccts;
        UserContext result = null;
        Identity authUser = null;
        try {
            authUser = (Identity)this.fAuthenticator.authenticate(am, context);
            if (authUser != null) {
                String authFor = context.request().getFirstHeader("X-AuthFor");
                if (authFor != null && authFor.length() > 0 && !authFor.equals(authUser.getId())) {
                    Identity authForUser = am.getIdentityDb().loadUser(authFor);
                    if (authForUser != null && authUser.getGroup(kContinualSystemsGroup) != null) {
                        result = new UserContext.Builder().forUser(authForUser).sponsoredByUser(authUser).build();
                    }
                } else {
                    result = new UserContext.Builder().forUser(authUser).build();
                }
            }
            return result;
        }
        catch (IamSvcException x) {
            log.warn("Error processing authentication: " + x.getMessage());
            throw x;
        }
    }

    protected IamService<I, ?> getInternalAccts() {
        return this.fAccts;
    }

    public static String getAcctsSvcName(JSONObject settings) {
        for (String key : kAcctSvcKeys) {
            String acctSvcName = settings.optString(key, null);
            if (acctSvcName == null) continue;
            return acctSvcName;
        }
        return kAcctSvcKeys[0];
    }

    public static class ResourceAccess {
        public final Resource fResource;
        public final String fOp;

        public ResourceAccess(String resourceId, String operation) {
            this.fResource = Resource.fromName((String)resourceId);
            this.fOp = operation;
        }
    }

    public static interface ApiHandler<I extends Identity> {
        public void handle(CHttpRequestContext var1, UserContext<I> var2) throws IOException;
    }

    public static interface Authenticator<I extends Identity> {
        public I authenticate(IamService<I, ?> var1, CHttpRequestContext var2) throws IamSvcException;
    }
}

