/*
 * Decompiled with CFR 0.152.
 */
package io.continual.http.app.servers.endpoints;

import io.continual.builder.Builder;
import io.continual.http.app.servers.endpoints.TypicalUiEndpoint;
import io.continual.http.service.framework.context.CHttpRequestContext;
import io.continual.http.service.framework.context.CHttpResponse;
import io.continual.iam.identity.Identity;
import io.continual.services.ServiceContainer;
import io.continual.util.data.StreamTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.json.JSONObject;

public class FileServer<I extends Identity>
extends TypicalUiEndpoint<I> {
    private File fBaseDir;

    public FileServer(ServiceContainer sc, JSONObject config) throws Builder.BuildFailure {
        String baseDir = sc.getExprEval().evaluateText(config.getString("baseDir"));
        this.fBaseDir = new File(baseDir);
        if (!this.fBaseDir.isDirectory()) {
            throw new Builder.BuildFailure(baseDir + " is not a directory.");
        }
    }

    public void getFile(CHttpRequestContext context, String path) {
        if (path.contains("..") || path.startsWith(File.pathSeparator)) {
            context.response().sendError(404, "Couldn't find " + path);
            return;
        }
        File f = new File(this.fBaseDir, path);
        if (!f.exists()) {
            context.response().sendError(404, "Couldn't find " + path);
            return;
        }
        try {
            CHttpResponse r = context.response();
            r.setStatus(200);
            r.setContentType("application/octet-stream");
            OutputStream os = context.response().getStreamForBinaryResponse();
            StreamTools.copyStream((InputStream)new FileInputStream(f), (OutputStream)os);
            os.close();
        }
        catch (FileNotFoundException e) {
            context.response().sendError(404, "Couldn't find " + path);
        }
        catch (IOException e) {
            context.response().sendError(503, "Couldn't read " + path);
        }
    }
}

