/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.data.json;

import io.continual.util.data.json.CommentedJsonTokener;
import io.continual.util.data.json.JsonEval;
import io.continual.util.data.json.JsonVisitor;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JsonUtil {
    private static final ZoneId kLocalZone = ZoneId.of("America/New_York");
    private static String[] dateFormats = new String[]{"yyyy.MM.dd HH:mm:ss z", "yyyyMMdd"};
    public static final String skKeyOrderArray = "__keyOrder";
    private static final String kTab = "    ";

    private JsonUtil() {
    }

    public static JSONObject readJsonObject(InputStream is) {
        return new JSONObject((JSONTokener)new CommentedJsonTokener(is));
    }

    public static JSONObject readJsonObject(String is) {
        return new JSONObject((JSONTokener)new CommentedJsonTokener(is));
    }

    public static JSONObject readJsonObject(Reader is) {
        return new JSONObject((JSONTokener)new CommentedJsonTokener(is));
    }

    public static JSONArray readJsonArray(InputStream is) {
        return new JSONArray((JSONTokener)new CommentedJsonTokener(is));
    }

    public static JSONArray readJsonArray(String is) {
        return new JSONArray((JSONTokener)new CommentedJsonTokener(is));
    }

    public static JSONArray readJsonArray(Reader is) {
        return new JSONArray((JSONTokener)new CommentedJsonTokener(is));
    }

    public static Object readJsonValue(String is) {
        return new CommentedJsonTokener(is).nextValue();
    }

    public static JSONObject clone(JSONObject that) {
        if (that == null) {
            return null;
        }
        return (JSONObject)JsonUtil.cloneJsonValue(that);
    }

    public static JSONArray clone(JSONArray that) {
        if (that == null) {
            return null;
        }
        return (JSONArray)JsonUtil.cloneJsonValue(that);
    }

    public static Object cloneJsonValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof JSONObject) {
            JSONObject result = new JSONObject();
            JSONObject obj = (JSONObject)value;
            for (Object key : obj.keySet()) {
                String keyStr = key.toString();
                result.put(keyStr, JsonUtil.cloneJsonValue(obj.get(keyStr)));
            }
            return result;
        }
        if (value instanceof JSONArray) {
            JSONArray array = (JSONArray)value;
            JSONArray result = new JSONArray();
            for (int i = 0; i < array.length(); ++i) {
                result.put(i, JsonUtil.cloneJsonValue(array.get(i)));
            }
            return result;
        }
        return value;
    }

    public static JSONObject overlay(JSONObject target, JSONObject overlay) {
        if (overlay == null) {
            return target;
        }
        if (target == null) {
            return null;
        }
        for (Object overlayKey : overlay.keySet()) {
            String overlayKeyStr = overlayKey.toString();
            Object currVal = target.opt(overlayKeyStr);
            Object newVal = overlay.get(overlayKeyStr);
            if (currVal instanceof JSONObject && newVal instanceof JSONObject) {
                JsonUtil.overlay((JSONObject)currVal, (JSONObject)newVal);
                continue;
            }
            if (newVal == JSONObject.NULL) {
                target.remove(overlayKeyStr);
                continue;
            }
            target.put(overlayKeyStr, JsonUtil.cloneJsonValue(newVal));
        }
        return target;
    }

    public static void copyInto(JSONObject src, JSONObject dest) {
        if (src == null || dest == null) {
            return;
        }
        for (Object key : src.keySet()) {
            String keyStr = key.toString();
            dest.put(keyStr, JsonUtil.cloneJsonValue(src.get(keyStr)));
        }
    }

    public static JSONObject putDefault(JSONObject obj, String key, Object val) {
        if (!obj.has(key)) {
            obj.put(key, val);
        }
        return obj;
    }

    public static int getIndexOfStringInArray(String s, JSONArray a) {
        if (a == null || s == null) {
            return -1;
        }
        int found = -1;
        for (int i = 0; i < a.length(); ++i) {
            if (!s.equals(a.getString(i))) continue;
            found = i;
            break;
        }
        return found;
    }

    public static boolean ensureStringInArray(String s, JSONArray a) {
        if (a == null || s == null) {
            return false;
        }
        int found = JsonUtil.getIndexOfStringInArray(s, a);
        if (found < 0) {
            a.put((Object)s);
            return true;
        }
        return false;
    }

    public static boolean removeStringFromArray(JSONArray a, String s) {
        if (a == null || s == null) {
            return false;
        }
        int found = JsonUtil.getIndexOfStringInArray(s, a);
        if (found > -1) {
            a.remove(found);
            return true;
        }
        return false;
    }

    public static void writeDate(JSONObject base, String key, Date d) throws JSONException {
        ZonedDateTime zdt = d.toInstant().atZone(kLocalZone);
        base.put(key, (Object)zdt.format(DateTimeFormatter.ISO_LOCAL_DATE));
    }

    public static void writeDateTime(JSONObject base, String key, Date d) throws JSONException {
        base.put(key, (Object)JsonUtil.writeDate(d));
    }

    public static String writeDate(Date d) throws JSONException {
        ZonedDateTime zdt = d.toInstant().atZone(kLocalZone);
        return zdt.format(DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public static String writeDate(LocalDate d) throws JSONException {
        return d.format(DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public static LocalDate readDate(JSONObject base, String key) throws JSONException {
        Object o = base.opt(key);
        if (o == null) {
            return null;
        }
        if (o instanceof Long) {
            Instant i = Instant.ofEpochMilli((Long)o);
            return i.atZone(kLocalZone).toLocalDate();
        }
        if (o instanceof String) {
            try {
                LocalDateTime ldt = LocalDateTime.parse((String)o);
                return ldt.toLocalDate();
            }
            catch (DateTimeParseException dateTimeParseException) {
                try {
                    return LocalDate.parse((String)o);
                }
                catch (DateTimeParseException dateTimeParseException2) {
                    for (String format : dateFormats) {
                        try {
                            SimpleDateFormat sdf = new SimpleDateFormat(format);
                            Date d = sdf.parse((String)o);
                            d.toInstant().atZone(kLocalZone).toLocalDate();
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        throw new JSONException("Unrecognized format for Date read.");
    }

    public static List<String> readStringArray(JSONObject base, String key) throws JSONException {
        return JsonUtil.readStringArray(base, key, null);
    }

    public static List<String> readStringArray(JSONObject base, String key, StringArrayValueParser parser) throws JSONException {
        final LinkedList<String> result = new LinkedList<String>();
        Object oo = base.opt(key);
        if (oo == null) {
            throw new JSONException(key + " does not exist");
        }
        if (oo instanceof JSONArray) {
            JsonVisitor.forEachStringElement((JSONArray)oo, new JsonVisitor.ArrayOfStringVisitor(){

                @Override
                public boolean visit(String str) throws JSONException {
                    result.add(str);
                    return true;
                }
            });
        } else {
            String val = oo.toString();
            if (parser != null) {
                result.addAll(parser.parse(val));
            } else {
                result.add(val);
            }
        }
        return result;
    }

    public static void sortArrayOfObjects(JSONArray a, String valueExpression) {
        JsonUtil.sortArrayOfObjects(a, valueExpression, false);
    }

    public static void sortArrayOfObjects(JSONArray a, final String valueExpression, boolean reverse) {
        final LinkedList list = new LinkedList();
        JsonVisitor.forEachObjectIn(a, new JsonVisitor.ArrayOfObjectVisitor(){

            @Override
            public boolean visit(JSONObject t) throws JSONException {
                if (t != null) {
                    list.add(t);
                }
                return true;
            }
        });
        Collections.sort(list, new Comparator<JSONObject>(){

            @Override
            public int compare(JSONObject o1, JSONObject o2) {
                Object oval1 = JsonEval.eval(o1, valueExpression);
                Object oval2 = JsonEval.eval(o2, valueExpression);
                if (oval1 instanceof Long && oval2 instanceof Long) {
                    Long n1 = (Long)oval1;
                    Long n2 = (Long)oval2;
                    return n1.compareTo(n2);
                }
                if (oval1 instanceof Integer && oval2 instanceof Integer) {
                    Integer n1 = (Integer)oval1;
                    Integer n2 = (Integer)oval2;
                    return n1.compareTo(n2);
                }
                String e1 = oval1 == null ? "" : oval1.toString();
                String e2 = oval2 == null ? "" : oval2.toString();
                return e1.compareTo(e2);
            }
        });
        if (reverse) {
            Collections.reverse(list);
        }
        int index = 0;
        for (JSONObject o : list) {
            a.put(index++, (Object)o);
        }
    }

    public static JSONObject resolveRef(JSONObject topLevel, JSONObject local) throws JSONException {
        if (local == null) {
            return null;
        }
        String ref = local.optString("$ref", null);
        if (ref == null) {
            return local;
        }
        String[] parts = ref.split("/");
        if (!parts[0].equals("#")) {
            throw new JSONException("Reference must start with #/");
        }
        JSONObject current = topLevel;
        for (int i = 1; i < parts.length; ++i) {
            if ((current = current.optJSONObject(parts[i])) != null) continue;
            return null;
        }
        return current;
    }

    public static String writeConsistently(Object o) {
        if (o instanceof JSONObject) {
            return JsonUtil.writeConsistently((JSONObject)o);
        }
        if (o instanceof JSONArray) {
            return JsonUtil.writeConsistently((JSONArray)o);
        }
        return JSONObject.valueToString((Object)o);
    }

    public static String writeConsistently(JSONArray a) {
        StringBuilder sb = new StringBuilder();
        sb.append("[\n");
        boolean doneOne = false;
        for (int i = 0; i < a.length(); ++i) {
            if (doneOne) {
                sb.append(",\n");
            }
            doneOne = true;
            sb.append(JsonUtil.writeConsistently(a.opt(i)));
        }
        sb.append("\n]\n");
        return sb.toString();
    }

    public static String writeConsistently(JSONObject o) {
        ArrayList keys = new ArrayList();
        keys.addAll(o.keySet());
        Collections.sort(keys);
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        boolean doneOne = false;
        for (String key : keys) {
            if (doneOne) {
                sb.append(",\n");
            }
            doneOne = true;
            sb.append(key).append(":").append(JsonUtil.writeConsistently(o.get(key)));
        }
        sb.append("\n}\n");
        return sb.toString();
    }

    public static int hash(JSONObject o) {
        return JsonUtil.writeConsistently(o).hashCode();
    }

    public static String writeWithKeyOrder(Object o) {
        return JsonUtil.writeWithKeyOrder(o, 0);
    }

    private static String writeWithKeyOrder(Object o, int currentIndent) {
        if (o instanceof JSONObject) {
            return JsonUtil.writeWithKeyOrder((JSONObject)o, currentIndent);
        }
        if (o instanceof JSONArray) {
            return JsonUtil.writeWithKeyOrder((JSONArray)o, currentIndent);
        }
        return JSONObject.valueToString((Object)o);
    }

    public static String writeWithKeyOrder(JSONArray a) {
        return JsonUtil.writeWithKeyOrder(a, 0);
    }

    private static String writeWithKeyOrder(JSONArray a, int currentIndent) {
        StringBuilder sb = new StringBuilder();
        sb.append("[\n");
        boolean doneOne = false;
        for (int i = 0; i < a.length(); ++i) {
            if (doneOne) {
                sb.append(",\n");
            }
            doneOne = true;
            for (int tab = 0; tab < currentIndent + 1; ++tab) {
                sb.append(kTab);
            }
            sb.append(JsonUtil.writeWithKeyOrder(a.opt(i), currentIndent + 1));
        }
        sb.append("\n");
        for (int tab = 0; tab < currentIndent; ++tab) {
            sb.append(kTab);
        }
        sb.append("]");
        return sb.toString();
    }

    public static String writeWithKeyOrder(JSONObject o) {
        return JsonUtil.writeWithKeyOrder(o, 0);
    }

    private static String writeWithKeyOrder(JSONObject o, int currentIndent) {
        JSONArray keyOrder = o.optJSONArray(skKeyOrderArray);
        if (keyOrder == null) {
            keyOrder = new JSONArray();
        }
        TreeSet unwrittenKeys = new TreeSet();
        unwrittenKeys.addAll(o.keySet());
        unwrittenKeys.remove(skKeyOrderArray);
        ArrayList<String> keysToWrite = new ArrayList<String>();
        for (int i = 0; i < keyOrder.length(); ++i) {
            String key = keyOrder.getString(i);
            keysToWrite.add(key);
            unwrittenKeys.remove(key);
        }
        ArrayList remainingKeys = new ArrayList();
        remainingKeys.addAll(unwrittenKeys);
        Collections.sort(remainingKeys);
        keysToWrite.addAll(remainingKeys);
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        for (int tab = 0; tab < currentIndent; ++tab) {
            sb.append(kTab);
        }
        boolean doneOne = false;
        for (String key : keysToWrite) {
            if (!o.has(key)) continue;
            if (doneOne) {
                sb.append(",\n");
                for (int tab = 0; tab < currentIndent; ++tab) {
                    sb.append(kTab);
                }
            }
            doneOne = true;
            sb.append(kTab).append(JSONObject.quote((String)key)).append(": ").append(JsonUtil.writeWithKeyOrder(o.get(key), currentIndent + 1));
        }
        sb.append("\n");
        for (int tab = 0; tab < currentIndent; ++tab) {
            sb.append(kTab);
        }
        sb.append("}");
        return sb.toString();
    }

    public static interface StringArrayValueParser {
        public Collection<String> parse(String var1);
    }
}

