/*
 * Decompiled with CFR 0.152.
 */
package io.continual.http.service.framework;

import io.continual.util.nv.NvReadable;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Loader;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.util.CustomObjectInputStream;
import org.apache.juli.logging.Log;
import org.apache.tomcat.util.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CHttpSessionManager
extends ManagerBase {
    protected static final String name = "CHttpSessionManager";
    protected String pathname = "SESSIONS.ser";
    private static final Logger log = LoggerFactory.getLogger(CHttpSessionManager.class);

    public CHttpSessionManager(NvReadable settings) {
    }

    public String getName() {
        return name;
    }

    public String getPathname() {
        return this.pathname;
    }

    public void setPathname(String pathname) {
        String oldPathname = this.pathname;
        this.pathname = pathname;
        this.support.firePropertyChange("pathname", oldPathname, this.pathname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws ClassNotFoundException, IOException {
        if (log.isDebugEnabled()) {
            log.debug("Start: Loading persisted sessions");
        }
        this.sessions.clear();
        File file = this.file();
        if (file == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("standardManager.loading", new Object[]{this.pathname}));
        }
        Loader loader = null;
        ClassLoader classLoader = null;
        Log logger = null;
        try (FileInputStream fis = new FileInputStream(file.getAbsolutePath());
             BufferedInputStream bis = new BufferedInputStream(fis);){
            Context c = this.getContext();
            loader = c.getLoader();
            logger = c.getLogger();
            if (loader != null) {
                classLoader = loader.getClassLoader();
            }
            if (classLoader == null) {
                classLoader = ((Object)((Object)this)).getClass().getClassLoader();
            }
            Map map = this.sessions;
            synchronized (map) {
                try (CustomObjectInputStream ois = new CustomObjectInputStream((InputStream)bis, classLoader, logger, this.getSessionAttributeValueClassNamePattern(), this.getWarnOnSessionAttributeFilterFailure());){
                    Integer count = (Integer)ois.readObject();
                    int n = count;
                    if (log.isDebugEnabled()) {
                        log.debug("Loading " + n + " persisted sessions");
                    }
                    for (int i = 0; i < n; ++i) {
                        StandardSession session = this.getNewSession();
                        session.readObjectData((ObjectInputStream)ois);
                        session.setManager((Manager)this);
                        this.sessions.put(session.getIdInternal(), session);
                        session.activate();
                        ++this.sessionCounter;
                    }
                }
                finally {
                    if (file.exists()) {
                        file.delete();
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            if (log.isDebugEnabled()) {
                log.debug("No persisted data file found");
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Finish: Loading persisted sessions");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unload() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("standardManager.unloading.debug"));
        }
        if (this.sessions.isEmpty()) {
            log.debug(sm.getString("standardManager.unloading.nosessions"));
            return;
        }
        File file = this.file();
        if (file == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("standardManager.unloading", new Object[]{this.pathname}));
        }
        ArrayList<StandardSession> list = new ArrayList<StandardSession>();
        try (FileOutputStream fos = new FileOutputStream(file.getAbsolutePath());
             BufferedOutputStream bos = new BufferedOutputStream(fos);
             ObjectOutputStream oos = new ObjectOutputStream(bos);){
            Map map = this.sessions;
            synchronized (map) {
                if (log.isDebugEnabled()) {
                    log.debug("Unloading " + this.sessions.size() + " sessions");
                }
                oos.writeObject(this.sessions.size());
                for (StandardSession session : this.sessions.values()) {
                    list.add(session);
                    session.passivate();
                    session.writeObjectData(oos);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Expiring " + list.size() + " persisted sessions");
        }
        for (StandardSession session : list) {
            try {
                session.expire(false);
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable((Throwable)t);
            }
            finally {
                session.recycle();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Unloading complete");
        }
    }

    protected synchronized void startInternal() throws LifecycleException {
        super.startInternal();
        try {
            this.load();
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable((Throwable)t);
            log.error(sm.getString("standardManager.managerLoad"), t);
        }
        this.setState(LifecycleState.STARTING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void stopInternal() throws LifecycleException {
        if (log.isDebugEnabled()) {
            log.debug("Stopping");
        }
        this.setState(LifecycleState.STOPPING);
        try {
            this.unload();
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable((Throwable)t);
            log.error(sm.getString("standardManager.managerUnload"), t);
        }
        Session[] sessions = this.findSessions();
        for (int i = 0; i < sessions.length; ++i) {
            Session session = sessions[i];
            try {
                if (!session.isValid()) continue;
                session.expire();
                continue;
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable((Throwable)t);
                continue;
            }
            finally {
                session.recycle();
            }
        }
        super.stopInternal();
    }

    protected File file() {
        Context context;
        ServletContext servletContext;
        File tempdir;
        if (this.pathname == null || this.pathname.length() == 0) {
            return null;
        }
        File file = new File(this.pathname);
        if (!file.isAbsolute() && (tempdir = (File)(servletContext = (context = this.getContext()).getServletContext()).getAttribute("javax.servlet.context.tempdir")) != null) {
            file = new File(tempdir, this.pathname);
        }
        return file;
    }
}

