/*
 * Decompiled with CFR 0.152.
 */
package io.continual.jsonHttpClient;

import io.continual.jsonHttpClient.HttpUsernamePasswordCredentials;
import io.continual.util.data.StreamTools;
import io.continual.util.data.json.CommentedJsonTokener;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

public interface JsonOverHttpClient {
    public HttpRequest newRequest();

    public static interface HttpRequest {
        public HttpRequest onPath(String var1);

        public HttpRequest asUser(HttpUsernamePasswordCredentials var1);

        public HttpRequest withHeader(String var1, String var2);

        public HttpRequest withHeaders(Map<String, String> var1);

        public HttpRequest withExplicitQueryString(String var1);

        public HttpRequest addQueryParam(String var1, String var2);

        public HttpRequest withQueryString(Map<String, String> var1);

        public HttpResponse get() throws HttpServiceException;

        public HttpResponse delete() throws HttpServiceException;

        public HttpResponse put(JSONObject var1) throws HttpServiceException;

        public HttpResponse patch(JSONObject var1) throws HttpServiceException;

        public HttpResponse post(JSONObject var1) throws HttpServiceException;

        public HttpResponse post(JSONArray var1) throws HttpServiceException;
    }

    public static interface HttpResponse
    extends AutoCloseable {
        public int getCode();

        public String getMessage();

        @Override
        public void close();

        default public JSONObject getBody() throws BodyFormatException {
            return this.getBody(new JsonObjectBodyFactory());
        }

        default public JSONArray getArrayBody() throws BodyFormatException {
            return this.getBody(new JsonArrayBodyFactory());
        }

        default public String getStringBody() throws BodyFormatException {
            return this.getBody(new BodyFactory<String>(){

                @Override
                public String getBody(long contentLength, String mimeType, InputStream byteStream) throws BodyFormatException {
                    try {
                        byte[] bytes = StreamTools.readBytes((InputStream)byteStream);
                        return new String(bytes, StandardCharsets.UTF_8);
                    }
                    catch (IOException e) {
                        throw new BodyFormatException(e);
                    }
                }
            });
        }

        public <T> T getBody(BodyFactory<T> var1) throws BodyFormatException;

        default public boolean isSuccess() {
            int code = this.getCode();
            return code >= 200 && code < 300;
        }

        default public boolean isAuthError() {
            return this.getCode() == 401;
        }

        default public boolean isNotFound() {
            return this.getCode() == 404;
        }

        default public boolean isClientError() {
            int code = this.getCode();
            return code >= 400 && code < 500;
        }

        default public boolean isServerError() {
            return this.getCode() >= 500;
        }
    }

    public static class JsonArrayBodyFactory
    implements BodyFactory<JSONArray> {
        @Override
        public JSONArray getBody(long contentLength, String mimeType, InputStream byteStream) {
            return new JSONArray((JSONTokener)new CommentedJsonTokener(byteStream));
        }
    }

    public static class JsonObjectBodyFactory
    implements BodyFactory<JSONObject> {
        @Override
        public JSONObject getBody(long contentLength, String mimeType, InputStream byteStream) {
            return new JSONObject((JSONTokener)new CommentedJsonTokener(byteStream));
        }
    }

    public static interface BodyFactory<T> {
        public T getBody(long var1, String var3, InputStream var4) throws BodyFormatException;
    }

    public static class BodyFormatException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public BodyFormatException(Exception x) {
            super(x);
        }

        public BodyFormatException(String msg) {
            super(msg);
        }

        public BodyFormatException(String msg, Exception x) {
            super(msg, x);
        }
    }

    public static class HttpServiceException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public HttpServiceException(String msg) {
            super(msg);
        }

        public HttpServiceException(Throwable t) {
            super(t);
        }

        public HttpServiceException(String msg, Throwable t) {
            super(msg, t);
        }
    }
}

