/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.CommonFields;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.requests.AbstractResponse;

public class FindCoordinatorResponse
extends AbstractResponse {
    private static final String COORDINATOR_KEY_NAME = "coordinator";
    private static final String NODE_ID_KEY_NAME = "node_id";
    private static final String HOST_KEY_NAME = "host";
    private static final String PORT_KEY_NAME = "port";
    private static final Schema FIND_COORDINATOR_BROKER_V0 = new Schema(new Field("node_id", Type.INT32, "The broker id."), new Field("host", Type.STRING, "The hostname of the broker."), new Field("port", Type.INT32, "The port on which the broker accepts requests."));
    private static final Schema FIND_COORDINATOR_RESPONSE_V0 = new Schema(CommonFields.ERROR_CODE, new Field("coordinator", FIND_COORDINATOR_BROKER_V0, "Host and port information for the coordinator for a consumer group."));
    private static final Schema FIND_COORDINATOR_RESPONSE_V1 = new Schema(CommonFields.THROTTLE_TIME_MS, CommonFields.ERROR_CODE, CommonFields.ERROR_MESSAGE, new Field("coordinator", FIND_COORDINATOR_BROKER_V0, "Host and port information for the coordinator"));
    private final int throttleTimeMs;
    private final String errorMessage;
    private final Errors error;
    private final Node node;

    public static Schema[] schemaVersions() {
        return new Schema[]{FIND_COORDINATOR_RESPONSE_V0, FIND_COORDINATOR_RESPONSE_V1};
    }

    public FindCoordinatorResponse(Errors error, Node node) {
        this(0, error, node);
    }

    public FindCoordinatorResponse(int throttleTimeMs, Errors error, Node node) {
        this.throttleTimeMs = throttleTimeMs;
        this.error = error;
        this.node = node;
        this.errorMessage = null;
    }

    public FindCoordinatorResponse(Struct struct) {
        this.throttleTimeMs = struct.getOrElse(CommonFields.THROTTLE_TIME_MS, 0);
        this.error = Errors.forCode(struct.get(CommonFields.ERROR_CODE));
        this.errorMessage = struct.getOrElse(CommonFields.ERROR_MESSAGE, null);
        Struct broker = (Struct)struct.get(COORDINATOR_KEY_NAME);
        int nodeId = broker.getInt(NODE_ID_KEY_NAME);
        String host = broker.getString(HOST_KEY_NAME);
        int port = broker.getInt(PORT_KEY_NAME);
        this.node = new Node(nodeId, host, port);
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public Errors error() {
        return this.error;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.errorCounts(this.error);
    }

    public Node node() {
        return this.node;
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.FIND_COORDINATOR.responseSchema(version));
        struct.setIfExists(CommonFields.THROTTLE_TIME_MS, (Object)this.throttleTimeMs);
        struct.set(CommonFields.ERROR_CODE, this.error.code());
        struct.setIfExists(CommonFields.ERROR_MESSAGE, (Object)this.errorMessage);
        Struct coordinator = struct.instance(COORDINATOR_KEY_NAME);
        coordinator.set(NODE_ID_KEY_NAME, (Object)this.node.id());
        coordinator.set(HOST_KEY_NAME, (Object)this.node.host());
        coordinator.set(PORT_KEY_NAME, (Object)this.node.port());
        struct.set(COORDINATOR_KEY_NAME, (Object)coordinator);
        return struct;
    }

    public static FindCoordinatorResponse parse(ByteBuffer buffer, short version) {
        return new FindCoordinatorResponse(ApiKeys.FIND_COORDINATOR.responseSchema(version).read(buffer));
    }

    public String toString() {
        return "FindCoordinatorResponse(throttleTimeMs=" + this.throttleTimeMs + ", errorMessage='" + this.errorMessage + '\'' + ", error=" + (Object)((Object)this.error) + ", node=" + this.node + ')';
    }
}

