/*
 * Decompiled with CFR 0.152.
 */
package io.continual.http.service.framework.routing.playish;

import io.continual.http.service.framework.context.CHttpRequestContext;
import io.continual.http.service.framework.routing.CHttpRouteInvocation;
import io.continual.http.service.framework.routing.CHttpRouteSource;
import io.continual.http.service.framework.routing.playish.CHttpPathInfo;
import io.continual.http.service.framework.routing.playish.InstanceEntryAction;
import io.continual.util.naming.Path;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CHttpPlayishInstanceCallRoutingSource<T>
implements CHttpRouteSource {
    private final T fInstance;
    private final LinkedList<String> fPackages;
    private final LinkedList<CHttpPathInfo> fPathList;
    private static final Logger log = LoggerFactory.getLogger(CHttpPlayishInstanceCallRoutingSource.class);

    public CHttpPlayishInstanceCallRoutingSource(T instance, URL url) throws IOException {
        this.fInstance = instance;
        this.fPathList = new LinkedList();
        this.fPackages = new LinkedList();
        if (url == null) {
            throw new IOException("URL for routing file is null in CHttpPlayishInstanceCallRoutingSource ( URL u )");
        }
        this.loadRoutes(url);
    }

    public CHttpPlayishInstanceCallRoutingSource(T instance, InputStream is) throws IOException {
        this.fInstance = instance;
        this.fPathList = new LinkedList();
        this.fPackages = new LinkedList();
        this.loadRoutes(is);
    }

    public synchronized CHttpPlayishInstanceCallRoutingSource<T> addRoute(String verb, String path, String action) {
        CHttpPathInfo pe = CHttpPathInfo.processPath(verb, path);
        pe.setHandler(new InstanceEntryAction<T>(this.fInstance, action, pe.getArgs(), this.fPackages));
        this.fPathList.add(pe);
        return this;
    }

    @Override
    public synchronized CHttpRouteInvocation getRouteFor(String verb, String path) {
        Invocation selected = null;
        for (CHttpPathInfo pe : this.fPathList) {
            List<String> args = pe.matches(verb, path);
            if (args == null) continue;
            selected = this.getInvocation(pe, args);
            break;
        }
        return selected;
    }

    @Override
    public String getRouteTo(Class<?> c, String staticMethodName, Map<String, Object> args) {
        String fullname = c.getName() + "." + staticMethodName;
        for (CHttpPathInfo pe : this.fPathList) {
            if (!pe.invokes(fullname)) continue;
            return pe.makePath(args);
        }
        return null;
    }

    protected Invocation getInvocation(CHttpPathInfo pe, List<String> args) {
        return new Invocation(pe, args);
    }

    protected synchronized void clearRoutes() {
        log.debug("Clearing routes within this instance route source.");
        this.fPathList.clear();
    }

    protected synchronized void addPackage(String pkg) {
        this.fPackages.add(pkg);
    }

    private synchronized void loadRoutes(URL u) throws IOException {
        this.loadRoutes(new InputStreamReader(u.openStream()));
    }

    private synchronized void loadRoutes(InputStream is) throws IOException {
        this.loadRoutes(new InputStreamReader(is));
    }

    private synchronized void loadRoutes(Reader r) throws IOException {
        String line;
        this.clearRoutes();
        BufferedReader fr = new BufferedReader(r);
        while ((line = fr.readLine()) != null) {
            if ((line = line.trim()).length() <= 0 || line.startsWith("#")) continue;
            this.processLine(line);
        }
    }

    private void processLine(String line) {
        try {
            StringTokenizer st = new StringTokenizer(line);
            String verb = st.nextToken();
            if (verb.toLowerCase().equals("package")) {
                String pkg = st.nextToken();
                this.addPackage(pkg);
            } else {
                String path = st.nextToken();
                String action = st.nextToken();
                this.addRoute(verb, path, action);
            }
        }
        catch (NoSuchElementException e) {
            log.warn("There was an error processing route config line: \"" + line + "\"");
        }
        catch (IllegalArgumentException e) {
            log.warn("There was an error processing route config line: \"" + line + "\": " + e.getMessage());
        }
    }

    protected class Invocation
    implements CHttpRouteInvocation {
        private final CHttpPathInfo fPe;
        private final List<String> fArgs;

        public Invocation(CHttpPathInfo pe, List<String> args) {
            this.fPe = pe;
            this.fArgs = args;
        }

        @Override
        public void run(CHttpRequestContext ctx) throws IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            this.fPe.getHandler().handle(ctx, this.fArgs);
        }

        @Override
        public Path getRouteNameForMetrics() {
            String pathPart = this.fPe.getPath();
            if (!pathPart.startsWith(Path.getPathSeparatorString())) {
                pathPart = Path.getPathSeparatorString() + pathPart;
            }
            if (pathPart.equals(Path.getPathSeparatorString())) {
                pathPart = "(root)";
            } else if (pathPart.endsWith(Path.getPathSeparatorString())) {
                pathPart = pathPart.substring(0, pathPart.length() - 1);
            }
            return Path.fromString((String)(Path.getPathSeparatorString() + this.fPe.getVerb() + pathPart));
        }
    }
}

