/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.db.file;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class BlockFile
implements Closeable {
    public static final long kBadHandle = -1L;
    private final File fUnderlyingFile;
    private RandomAccessFile fFile;
    private final boolean fCanWrite;
    private final int fMajor;
    private final int fMinor;
    private final int fBlockSize;
    private final int fBlockDataSize;
    private long fDeleteChain;
    private boolean fCurrentIsLast;
    private long fCurrentNextOrSize;
    private byte[] fCurrentBlockData;
    private PBEParameterSpec fParamSpec;
    private SecretKey fKey;
    private static final int kSaltSize = 8;
    private static final int kHeaderLength = 32;
    private static final int kDeleteChainPointerLocation = 16;
    private static final int kOffsetToBlockData = 8;
    private static final int kPbeIterationCount = 1000;
    private static final int kPbeKeyLength = 8;

    public static void initialize(File file, int blockSize) throws IOException {
        if (blockSize < 9) {
            throw new IllegalArgumentException("The block size is too small.");
        }
        RandomAccessFile f = new RandomAccessFile(file, "rw");
        f.setLength(0L);
        f.seek(0L);
        f.write("rrbf".getBytes(Charset.forName("UTF-8")));
        f.writeInt(1);
        f.writeInt(0);
        f.writeInt(blockSize);
        f.writeLong(-1L);
        byte[] salt = SecureRandom.getSeed(8);
        f.write(salt);
        f.close();
    }

    public BlockFile(File file) throws IOException {
        this(file, true);
    }

    public BlockFile(File file, boolean withWrite) throws IOException {
        this(file, withWrite, null);
    }

    public BlockFile(File file, boolean withWrite, String passwd) throws IOException {
        this.fUnderlyingFile = file;
        this.fFile = new RandomAccessFile(file, withWrite ? "rw" : "r");
        this.fCanWrite = withWrite;
        this.fFile.seek(0L);
        byte[] tag = new byte[4];
        this.fFile.read(tag);
        String tagString = new String(tag);
        if (!tagString.equals("rrbf")) {
            throw new IOException("unrecognized file format");
        }
        this.fMajor = this.fFile.readInt();
        this.fMinor = this.fFile.readInt();
        if (this.fMajor != 1 || this.fMinor != 0) {
            throw new IOException("unrecognized file format");
        }
        this.fBlockSize = this.fFile.readInt();
        this.fCurrentBlockData = new byte[this.fBlockSize];
        this.fBlockDataSize = this.fBlockSize - 8;
        this.fDeleteChain = this.fFile.readLong();
        if (passwd != null) {
            byte[] saltBytes = new byte[8];
            this.fFile.read(saltBytes);
            this.initKey(passwd, saltBytes);
        }
    }

    public String getFilePath() {
        return this.fUnderlyingFile.getAbsolutePath();
    }

    @Override
    public void close() throws IOException {
        this.fFile.close();
    }

    public long indexToAddress(long index) {
        return 32L + index * (long)this.fBlockSize;
    }

    public long create(byte[] bytes) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        return this.create(bais);
    }

    public long create(InputStream is) throws IOException {
        long result = this.allocateBlock();
        OutputStream os = this.writeStream(result);
        this.copyStream(is, os);
        os.close();
        return result;
    }

    public byte[] read(long address) throws IOException {
        InputStream in = this.readToStream(address);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.copyStream(in, baos);
        baos.close();
        return baos.toByteArray();
    }

    public InputStream readToStream(long address) throws IOException {
        InputStream result = new blockReadStream(address);
        if (this.fKey != null) {
            result = new CipherInputStream(result, this.getCipher(false));
        }
        return result;
    }

    public void append(long address, byte[] bytes) throws IOException {
        if (this.fKey != null) {
            byte[] thereNow = this.read(address);
            OutputStream os = this.writeStream(address);
            os.write(thereNow);
            os.write(bytes);
            os.close();
        } else {
            long lastBlock = this.getLastBlockInChain(address);
            byte[] thereNow = this.read(lastBlock);
            OutputStream os = this.writeStream(lastBlock);
            os.write(thereNow);
            os.write(bytes);
            os.close();
        }
    }

    public void overwrite(long address, byte[] bytes) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        this.overwrite(address, bais);
    }

    public void overwrite(long address, InputStream bytes) throws IOException {
        if (address < 32L) {
            throw new IOException("Address " + address + " is in the header block. (Did you mean to use indexToAddress?)");
        }
        OutputStream os = this.writeStream(address);
        this.copyStream(bytes, os);
        os.close();
    }

    public void delete(long address) throws IOException {
        if (!this.fCanWrite) {
            throw new IOException("opened read-only");
        }
        long current = this.getLastBlockInChain(address);
        this.storeBlock(current, this.fDeleteChain, new byte[0]);
        this.fDeleteChain = address;
        this.writeDeleteChainPointer();
    }

    void copyStream(InputStream is, OutputStream os) throws IOException {
        BlockFile.copyStream(is, os, this.fBlockSize);
    }

    static void copyStream(InputStream is, OutputStream os, int bufferSize) throws IOException {
        int len;
        byte[] buffer = new byte[bufferSize];
        while ((len = is.read(buffer)) != -1) {
            os.write(buffer, 0, len);
        }
    }

    private long allocateBlock() throws IOException {
        long result = -1L;
        if (this.fDeleteChain != -1L) {
            result = this.fDeleteChain;
            this.fDeleteChain = this.getNextBlockFrom(result);
            this.writeDeleteChainPointer();
        } else {
            result = this.fFile.length();
            this.storeBlock(result, new byte[0], 0);
        }
        return result;
    }

    private void writeDeleteChainPointer() throws IOException {
        this.fFile.seek(16L);
        this.fFile.writeLong(this.fDeleteChain);
    }

    private void loadBlock(long address) throws IOException {
        long maxAddress = this.fFile.length();
        if (address == maxAddress) {
            this.fCurrentIsLast = true;
            this.fCurrentNextOrSize = 0L;
            this.fCurrentBlockData = new byte[0];
        } else {
            this.fFile.seek(address);
            int expect = this.fBlockDataSize;
            long sizeData = this.fFile.readLong();
            if (sizeData >= 0L) {
                this.fCurrentIsLast = true;
                this.fCurrentNextOrSize = sizeData;
                expect = (int)(this.fCurrentNextOrSize & 0xFFFFL);
            } else {
                this.fCurrentIsLast = false;
                this.fCurrentNextOrSize = -1L * sizeData;
            }
            this.fCurrentBlockData = new byte[expect];
            if (expect > this.fFile.read(this.fCurrentBlockData)) {
                throw new IOException("block size too small");
            }
        }
    }

    private OutputStream writeStream(long address) throws IOException {
        OutputStream result = new blockOutputStream(address);
        if (this.fKey != null) {
            result = new CipherOutputStream(result, this.getCipher(true));
        }
        return result;
    }

    private void storeBlock(long thisBlock, long nextBlock, byte[] bytes) throws IOException {
        this.fFile.seek(thisBlock);
        if (nextBlock == -1L) {
            this.fFile.writeLong(bytes.length);
        } else {
            this.fFile.writeLong(-1L * nextBlock);
        }
        byte[] block = new byte[this.fBlockDataSize];
        System.arraycopy(bytes, 0, block, 0, bytes.length);
        this.fFile.write(block);
    }

    private void storeBlock(long thisBlock, byte[] bytes, int size) throws IOException {
        if (size < 0) {
            throw new IllegalArgumentException("Data size in last block may not be less than 0.");
        }
        long nextBlockWas = this.getNextBlockFrom(thisBlock);
        this.fFile.seek(thisBlock);
        this.fFile.writeLong(size);
        byte[] block = new byte[this.fBlockDataSize];
        System.arraycopy(bytes, 0, block, 0, size);
        this.fFile.write(block);
        if (nextBlockWas != -1L) {
            this.delete(nextBlockWas);
        }
    }

    private long getLastBlockInChain(long handle) throws IOException {
        long current = handle;
        long next = this.getNextBlockFrom(current);
        while (next != -1L) {
            current = next;
            next = this.getNextBlockFrom(current);
        }
        return current;
    }

    private long getNextBlockFrom(long handle) throws IOException {
        long result = -1L;
        if (handle != this.fFile.length()) {
            this.fFile.seek(handle);
            long nextOrSize = this.fFile.readLong();
            if (nextOrSize < -1L) {
                result = nextOrSize * -1L;
            }
        }
        return result;
    }

    private Cipher getCipher(boolean toEncrypt) throws IOException {
        if (this.fKey == null) {
            throw new IOException("Attempt to create cipher without key initialization.");
        }
        try {
            Cipher cipher = Cipher.getInstance(this.fKey.getAlgorithm());
            cipher.init(toEncrypt ? 1 : 2, (Key)this.fKey, this.fParamSpec);
            return cipher;
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
    }

    private void initKey(String password, byte[] salt) throws IOException {
        try {
            PBEKeySpec keySpec = new PBEKeySpec(password.toCharArray(), salt, 1000, 8);
            this.fParamSpec = new PBEParameterSpec(keySpec.getSalt(), keySpec.getIterationCount());
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("PBE");
            this.fKey = keyFactory.generateSecret(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
        catch (InvalidKeySpecException e) {
            throw new IOException(e);
        }
    }

    private class blockReadStream
    extends InputStream {
        private long fCurrReadBlock;
        private int fOffset;

        public blockReadStream(long addr) throws IOException {
            this.fCurrReadBlock = addr;
            BlockFile.this.loadBlock(this.fCurrReadBlock);
            this.fOffset = 0;
        }

        @Override
        public int read() throws IOException {
            if (this.fCurrReadBlock == -1L) {
                return -1;
            }
            int dataInBlock = BlockFile.this.fCurrentBlockData.length;
            if (this.fOffset >= dataInBlock) {
                if (!BlockFile.this.fCurrentIsLast) {
                    this.fCurrReadBlock = BlockFile.this.fCurrentNextOrSize;
                    BlockFile.this.loadBlock(this.fCurrReadBlock);
                    this.fOffset = 0;
                } else {
                    this.fCurrReadBlock = -1L;
                }
            }
            int result = -1;
            if (this.fCurrReadBlock != -1L) {
                result = 0xFF & BlockFile.this.fCurrentBlockData[this.fOffset++];
            }
            return result;
        }
    }

    private class blockOutputStream
    extends OutputStream {
        private long fCurrentBlock;
        private byte[] fBuffer;
        private int fSize;

        public blockOutputStream(long address) throws IOException {
            if (!BlockFile.this.fCanWrite) {
                throw new IOException("opened read-only");
            }
            this.fCurrentBlock = address;
            this.fBuffer = new byte[BlockFile.this.fBlockDataSize];
            this.fSize = 0;
        }

        @Override
        public void write(int b) throws IOException {
            if (b > 127 || b < -128) {
                throw new IOException("byte value out of range");
            }
            byte bb = (byte)(b & 0xFF);
            if (this.fSize < BlockFile.this.fBlockDataSize) {
                this.fBuffer[this.fSize++] = bb;
            } else {
                long nextBlock = BlockFile.this.allocateBlock();
                BlockFile.this.storeBlock(this.fCurrentBlock, nextBlock, this.fBuffer);
                this.fCurrentBlock = nextBlock;
                this.fSize = 1;
                this.fBuffer[0] = bb;
            }
        }

        @Override
        public void close() throws IOException {
            BlockFile.this.storeBlock(this.fCurrentBlock, this.fBuffer, this.fSize);
        }
    }
}

