/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.data.json;

import io.continual.util.data.json.JsonSerialized;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonVisitor {
    private JsonVisitor() {
    }

    public static <T, E extends Exception> void forEachElement(JSONArray a, ArrayVisitor<T, E> v) throws JSONException, E {
        Object o;
        if (a == null) {
            return;
        }
        int len = a.length();
        for (int i = 0; i < len && ((o = a.get(i)) == null || v.visit(o)); ++i) {
        }
    }

    public static void forEachStringElement(JSONArray a, ArrayOfStringVisitor v) throws JSONException {
        JsonVisitor.forEachElement(a, v);
    }

    public static void forEachObjectIn(JSONArray a, ArrayOfObjectVisitor v) throws JSONException {
        JsonVisitor.forEachElement(a, v);
    }

    public static HashMap<String, String> objectToMap(JSONObject obj) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (obj != null) {
            for (Object oo : obj.keySet()) {
                String key = oo.toString();
                String val = obj.getString(key);
                map.put(key, val);
            }
        }
        return map;
    }

    public static <T> HashMap<String, T> objectToMap(JSONObject obj, ItemRenderer<Object, T> ir) {
        return JsonVisitor.objectToMap(obj, new KeyRenderer<String>(){

            @Override
            public String render(String key) {
                return key;
            }
        }, ir);
    }

    public static <K, T> HashMap<K, T> objectToMap(JSONObject obj, KeyRenderer<K> kr, ItemRenderer<Object, T> ir) {
        HashMap<K, T> map = new HashMap<K, T>();
        if (obj != null) {
            for (Object oo : obj.keySet()) {
                String keyStr = oo.toString();
                K key = kr.render(keyStr);
                T val = ir.render(obj.get(keyStr));
                map.put(key, val);
            }
        }
        return map;
    }

    public static List<JSONObject> findMatchingObjects(JSONArray a, final ObjectFilter of) {
        final LinkedList<JSONObject> result = new LinkedList<JSONObject>();
        JsonVisitor.forEachObjectIn(a, new ArrayOfObjectVisitor(){

            @Override
            public boolean visit(JSONObject item) throws JSONException {
                if (of.matches(item)) {
                    result.add(item);
                }
                return true;
            }
        });
        return result;
    }

    public static boolean listContains(JSONArray a, String t) {
        if (a == null) {
            return false;
        }
        int len = a.length();
        for (int i = 0; i < len; ++i) {
            String s;
            Object o = a.get(i);
            if (o == null || !(s = o.toString()).equals(t)) continue;
            return true;
        }
        return false;
    }

    public static <T, F> List<T> arrayToList(JSONArray a, final ValueReader<F, T> vr) {
        final LinkedList list = new LinkedList();
        if (a != null) {
            JsonVisitor.forEachElement(a, new ArrayVisitor<F, JSONException>(){

                @Override
                public boolean visit(F t) throws JSONException {
                    list.add(vr.read(t));
                    return true;
                }
            });
        }
        return list;
    }

    public static List<String> arrayToList(JSONArray a) {
        final LinkedList<String> list = new LinkedList<String>();
        if (a != null) {
            JsonVisitor.forEachElement(a, new ArrayVisitor<Object, JSONException>(){

                @Override
                public boolean visit(Object t) throws JSONException {
                    if (t != null) {
                        list.add(t.toString());
                    }
                    return true;
                }
            });
        }
        return list;
    }

    public static List<Integer> arrayToIntList(JSONArray a) {
        final LinkedList<Integer> list = new LinkedList<Integer>();
        if (a != null) {
            JsonVisitor.forEachElement(a, new ArrayVisitor<Integer, JSONException>(){

                @Override
                public boolean visit(Integer t) throws JSONException {
                    list.add(t);
                    return true;
                }
            });
        }
        return list;
    }

    public static <T> JSONArray listToArray(String[] list) {
        return JsonVisitor.listToArray(Arrays.asList(list));
    }

    public static <T> JSONArray listToArray(Collection<T> list) {
        return JsonVisitor.listToArray(list, new StdItemRenderer());
    }

    public static <T, O> JSONArray listToArray(Collection<T> list, ItemRenderer<T, O> renderer) {
        return JsonVisitor.collectionToArray(list, renderer);
    }

    public static <T> JSONArray collectionToArray(Collection<T> list) {
        return JsonVisitor.collectionToArray(list, new StdItemRenderer());
    }

    public static <T, O> JSONArray collectionToArray(Collection<T> list, ItemRenderer<T, O> renderer) {
        if (list == null) {
            return null;
        }
        JSONArray a = new JSONArray();
        for (T o : list) {
            a.put(renderer.render(o));
        }
        return a;
    }

    public static JSONObject mapOfStringsToObject(Map<String, String> list) {
        JSONObject obj = new JSONObject();
        for (Map.Entry<String, String> e : list.entrySet()) {
            obj.put(e.getKey(), (Object)e.getValue());
        }
        return obj;
    }

    public static JSONObject mapToObject(Map<String, Integer> list) {
        return JsonVisitor.mapToObject(list, i -> i);
    }

    public static <T, O> JSONObject mapToObject(Map<String, T> list, ItemRenderer<T, O> renderer) {
        JSONObject obj = new JSONObject();
        for (Map.Entry<String, T> e : list.entrySet()) {
            obj.put(e.getKey(), renderer.render(e.getValue()));
        }
        return obj;
    }

    public static <T, E extends Exception> void forEachElement(JSONObject object, ObjectVisitor<T, E> v) throws JSONException, E {
        JsonVisitor.forEachElement(object, v, false);
    }

    public static <T, E extends Exception> void forEachElement(JSONObject object, ObjectVisitor<T, E> v, boolean allowNulls) throws JSONException, E {
        Object keyObj;
        String key;
        Object val;
        if (object == null) {
            return;
        }
        Iterator iterator = object.keySet().iterator();
        while (iterator.hasNext() && !((val = object.get(key = (keyObj = iterator.next()).toString())) == JSONObject.NULL && allowNulls ? !v.visit(key, null) : !v.visit(key, val))) {
        }
    }

    public static interface ArrayVisitor<T, E extends Exception> {
        public boolean visit(T var1) throws JSONException, E;
    }

    public static interface KeyRenderer<K> {
        public K render(String var1);
    }

    public static interface ItemRenderer<T, O> {
        public O render(T var1) throws IllegalArgumentException;
    }

    public static interface ObjectFilter {
        public boolean matches(JSONObject var1);
    }

    public static interface ArrayOfObjectVisitor
    extends ArrayVisitor<JSONObject, JSONException> {
    }

    public static interface ValueReader<F, T> {
        public T read(F var1);
    }

    public static class StdItemRenderer<T>
    implements ItemRenderer<T, Object> {
        @Override
        public Object render(T t) {
            if (t instanceof JsonSerialized) {
                return ((JsonSerialized)t).toJson();
            }
            return t;
        }
    }

    public static interface ObjectVisitor<T, E extends Exception> {
        public boolean visit(String var1, T var2) throws JSONException, E;
    }

    public static interface ArrayOfStringVisitor
    extends ArrayVisitor<String, JSONException> {
    }
}

