/*
 * Decompiled with CFR 0.152.
 */
package io.continual.http.service.framework.context;

import io.continual.http.service.framework.CHttpSession;
import io.continual.http.service.framework.context.CHttpRequest;
import io.continual.http.service.framework.context.CHttpRequestContext;
import io.continual.http.service.framework.context.CHttpResponse;
import io.continual.http.service.framework.context.StdRequest;
import io.continual.http.service.framework.context.StdResponse;
import io.continual.http.service.framework.inspection.CHttpObserver;
import io.continual.http.service.framework.routing.CHttpRequestRouter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletRequestContext
extends CHttpRequestContext {
    private final HttpServletRequest fRequest;
    private final HttpServletResponse fResponse;
    private StdRequest fRequestWrapper;
    private StdResponse fResponseWrapper;
    static Logger log = LoggerFactory.getLogger(ServletRequestContext.class);

    public ServletRequestContext(HttpServletRequest req, HttpServletResponse resp, CHttpSession s, CHttpRequestRouter router) {
        super(s, router);
        this.fRequest = req;
        this.fResponse = resp;
        this.fRequestWrapper = null;
        this.fResponseWrapper = null;
    }

    public void install(CHttpObserver i) {
        super.install(i);
        this.fRequestWrapper = null;
        this.fResponseWrapper = null;
    }

    public String servletPathToFullUrl(String contentUrl) {
        StringBuilder url = new StringBuilder();
        String scheme = this.fRequest.getScheme().toLowerCase();
        url.append(scheme);
        url.append("://");
        url.append(this.fRequest.getServerName());
        int serverPort = this.fRequest.getServerPort();
        if (!(scheme.equals("http") && serverPort == 80 || scheme.equals("https") && serverPort == 443)) {
            url.append(":");
            url.append(serverPort);
        }
        String path = this.servletPathToFullPath(contentUrl);
        url.append(path);
        log.info("calculated full URL for [" + contentUrl + "]: [" + url + "]");
        return url.toString();
    }

    public String servletPathToFullPath(String contentUrl) {
        return ServletRequestContext.servletPathToFullPath(contentUrl, this.fRequest);
    }

    public static String servletPathToFullPath(String contentUrl, HttpServletRequest req) {
        StringBuilder sb = new StringBuilder();
        String contextPart = req.getContextPath();
        sb.append(contextPart);
        String servletPart = req.getServletPath();
        sb.append(servletPart);
        sb.append(contentUrl);
        log.info("calculated full path for [" + contentUrl + "]: context=[" + contextPart + "], servlet=[" + servletPart + "], result=[" + sb.toString() + "]");
        return sb.toString();
    }

    public CHttpRequest request() {
        if (this.fRequestWrapper == null) {
            this.fRequestWrapper = new StdRequest(this.fRequest, this.inspector());
        }
        return this.fRequestWrapper;
    }

    public CHttpResponse response() {
        if (this.fResponseWrapper == null) {
            this.fResponseWrapper = new StdResponse(this.fRequest, this.fResponse, this.router(), this.inspector());
        }
        return this.fResponseWrapper;
    }
}

