/*
 * Decompiled with CFR 0.152.
 */
package io.continual.http.service.framework;

import io.continual.builder.Builder;
import io.continual.http.service.framework.CHttpFilter;
import io.continual.http.service.framework.CHttpRouteInstaller;
import io.continual.http.service.framework.CHttpService;
import io.continual.http.service.framework.CHttpServlet;
import io.continual.http.service.framework.inspection.CHttpObserverMgr;
import io.continual.iam.IamService;
import io.continual.metrics.MetricsCatalog;
import io.continual.metrics.MetricsService;
import io.continual.metrics.impl.noop.NoopMetricsCatalog;
import io.continual.services.Service;
import io.continual.services.ServiceContainer;
import io.continual.util.data.StreamTools;
import io.continual.util.data.json.JsonUtil;
import io.continual.util.data.json.JsonVisitor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import javax.servlet.Servlet;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Tomcat;
import org.apache.coyote.http11.Http11NioProtocol;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomcatHttpService
extends CHttpService {
    private final String kSetting_ServletWorkDir = "workDir";
    private final String kDefault_ServletWorkDir;
    private final String kSetting_TomcatBaseDir = "baseDir";
    private final String kDefault_TomcatBaseDir = "${CONTINUAL_TOMCAT_BASEDIR}";
    private final String kSetting_Keystore = "keystore";
    private final String kSetting_KeystoreFile = "file";
    private final String kSetting_KeystoreType = "type";
    private final String kDefault_KeystoreType = "JKS";
    private final String kSetting_KeystoreAlias = "alias";
    private final String kDefault_KeystoreAlias = "tomcat";
    private final String kSetting_KeystoreAliasScan = "scanForAlias";
    private final String kSetting_KeystorePassword = "password";
    private final String kDefault_KeystorePassword = "changeme";
    private final String kSetting_KeystorePasswordFile = "passwordFile";
    private static final String kSetting_Port = "port";
    private static final int kDefault_HttpPort = 8080;
    private static final int kDefault_HttpsPort = 8443;
    private final String fName;
    private final Tomcat fTomcat;
    private boolean fRunning;
    private final File fWorkDir;
    private final CHttpServlet.SessionLifeCycle fLifeCycle;
    @Deprecated
    private final JSONObject fSettings;
    private final IamService<?, ?> fAccounts;
    private final MetricsCatalog fMetrics;
    private final CHttpObserverMgr fInspector;
    private static final Logger log = LoggerFactory.getLogger(TomcatHttpService.class);

    public TomcatHttpService(ServiceContainer sc, JSONObject rawConfig) throws Builder.BuildFailure {
        block23: {
            super(sc, rawConfig);
            this.kSetting_ServletWorkDir = "workDir";
            this.kDefault_ServletWorkDir = new File(System.getProperty("java.io.tmpdir")).getAbsolutePath();
            this.kSetting_TomcatBaseDir = "baseDir";
            this.kDefault_TomcatBaseDir = "${CONTINUAL_TOMCAT_BASEDIR}";
            this.kSetting_Keystore = "keystore";
            this.kSetting_KeystoreFile = "file";
            this.kSetting_KeystoreType = "type";
            this.kDefault_KeystoreType = "JKS";
            this.kSetting_KeystoreAlias = "alias";
            this.kDefault_KeystoreAlias = "tomcat";
            this.kSetting_KeystoreAliasScan = "scanForAlias";
            this.kSetting_KeystorePassword = "password";
            this.kDefault_KeystorePassword = "changeme";
            this.kSetting_KeystorePasswordFile = "passwordFile";
            try {
                Connector connector;
                int port;
                JSONObject settings = sc.getExprEval().evaluateJsonObject(rawConfig);
                this.fSettings = JsonUtil.clone((JSONObject)settings);
                this.fName = settings.optString("name", "<anonymous>");
                this.fRunning = false;
                this.fLifeCycle = CHttpServlet.SessionLifeCycle.valueOf(settings.optString("lifeCycle", CHttpServlet.SessionLifeCycle.NO_SESSION.toString()));
                this.fAccounts = (IamService)sc.getReqdIfNotNull(settings.optString("accountService", null), IamService.class);
                MetricsService ms = (MetricsService)sc.getReqdIfNotNull(settings.optString("metricsService", null), MetricsService.class);
                this.fMetrics = ms == null ? new NoopMetricsCatalog() : ms.getCatalog("http");
                this.fInspector = (CHttpObserverMgr)sc.getReqdIfNotNull(settings.optString("inspector", null), CHttpObserverMgr.class);
                System.setProperty("org.apache.tomcat.util.buf.UDecoder.ALLOW_ENCODED_SLASH", "true");
                this.fTomcat = new Tomcat();
                String tomcatBaseDir = sc.getExprEval().evaluateText(settings.optString("baseDir", "${CONTINUAL_TOMCAT_BASEDIR}"));
                if (tomcatBaseDir != null && tomcatBaseDir.length() > 0) {
                    this.fTomcat.setBaseDir(tomcatBaseDir);
                }
                String servletWorkDir = settings.optString("workDir", this.kDefault_ServletWorkDir);
                this.fWorkDir = new File(servletWorkDir);
                if (!this.fWorkDir.exists()) {
                    this.fWorkDir.mkdirs();
                }
                JSONObject httpConfig = settings.optJSONObject("http");
                JSONObject httpsConfig = settings.optJSONObject("https");
                if (httpConfig == null && httpsConfig == null) {
                    httpConfig = new JSONObject().put(kSetting_Port, settings.optInt(kSetting_Port, 8080));
                }
                if (httpConfig != null) {
                    port = httpConfig.optInt(kSetting_Port, 8080);
                    if (port > 0) {
                        connector = new Connector(Http11NioProtocol.class.getName());
                        connector.setPort(port);
                        this.transferConnectorAttributes(connector, httpConfig.optJSONObject("tomcat"));
                        this.fTomcat.getService().addConnector(connector);
                        log.info("Service [{}] listens for HTTP on {}.", (Object)this.fName, (Object)port);
                    } else {
                        log.info("Service [{}] will not listen for HTTP.", (Object)this.fName);
                    }
                }
                if (httpsConfig == null) break block23;
                port = httpsConfig.optInt(kSetting_Port, 8443);
                if (port > 0) {
                    connector = new Connector(Http11NioProtocol.class.getName());
                    JSONObject keystoreConfig = httpsConfig.getJSONObject("keystore");
                    String keystoreFilename = keystoreConfig.getString("file");
                    File keystoreFile = new File(keystoreFilename);
                    if (!keystoreFile.isAbsolute()) {
                        Path path = FileSystems.getDefault().getPath(".", new String[0]).toAbsolutePath();
                        File file = new File(path.toFile(), keystoreFilename);
                        keystoreFilename = file.getAbsolutePath();
                        log.info("Using absolute path [" + keystoreFilename + "] for keystore.");
                    }
                    String keystorePassword = "changeme";
                    if (keystoreConfig.has("password")) {
                        keystorePassword = keystoreConfig.getString("password");
                    } else if (keystoreConfig.has("passwordFile")) {
                        String pwdFileName = keystoreConfig.optString("passwordFile", null);
                        File pwdFile = new File(pwdFileName);
                        try (FileInputStream fis = new FileInputStream(pwdFile);){
                            byte[] pwdData = StreamTools.readBytes((InputStream)fis);
                            keystorePassword = new String(pwdData).trim();
                        }
                        catch (IOException x) {
                            log.warn("There was a problem trying to read {}: {}", (Object)pwdFileName, (Object)x.getMessage());
                        }
                    }
                    String keystoreType = keystoreConfig.optString("type", "JKS");
                    String keystoreAlias = "tomcat";
                    if (keystoreConfig.has("alias")) {
                        keystoreAlias = keystoreConfig.getString("alias");
                    } else if (keystoreConfig.optBoolean("scanForAlias", false)) {
                        keystoreAlias = TomcatHttpService.scanKeystoreForPrivateKey(keystoreFilename, keystorePassword, keystoreType);
                    }
                    connector.setScheme("https");
                    connector.setSecure(true);
                    connector.setProperty("keystoreFile", keystoreFilename);
                    connector.setProperty("keystorePass", keystorePassword);
                    connector.setProperty("keystoreType", keystoreType);
                    connector.setProperty("keyAlias", keystoreAlias);
                    connector.setProperty("clientAuth", "false");
                    connector.setProperty("sslProtocol", "TLS");
                    connector.setProperty("SSLEnabled", "true");
                    connector.setPort(port);
                    this.transferConnectorAttributes(connector, httpsConfig.optJSONObject("tomcat"));
                    this.fTomcat.getService().addConnector(connector);
                    log.info("Service [{}] listens for HTTPS on {}.", (Object)this.fName, (Object)port);
                    break block23;
                }
                log.info("Service [{}] will not listen for HTTPS.", (Object)this.fName);
            }
            catch (JSONException x) {
                throw new Builder.BuildFailure((Throwable)x);
            }
        }
    }

    public synchronized void start() throws Service.FailedToStart {
        try {
            CHttpServlet hs = new CHttpServlet(this.fSettings, this.fLifeCycle, this.fMetrics, this.fInspector, this.fAccounts);
            for (CHttpRouteInstaller router : this.getRouteInstallers()) {
                hs.addRouter(router);
            }
            for (CHttpFilter filter : this.getFilters()) {
                hs.addFilter(filter);
            }
            String servletName = "httpService";
            Context rootCtx = this.fTomcat.addContext("", this.fWorkDir.getAbsolutePath());
            Tomcat.addServlet((Context)rootCtx, (String)"httpService", (Servlet)hs);
            rootCtx.addServletMappingDecoded("/*", "httpService");
            try {
                this.fTomcat.start();
                this.fRunning = true;
            }
            catch (LifecycleException e) {
                log.warn("Couldn't start tomcat.", (Throwable)e);
                throw new Service.FailedToStart((Throwable)e);
            }
            log.info("Service [{}] is listening.", (Object)this.fName);
        }
        catch (Builder.BuildFailure x) {
            throw new Service.FailedToStart((Throwable)x);
        }
    }

    public synchronized void requestFinish() {
        try {
            this.fTomcat.stop();
            this.fRunning = false;
        }
        catch (LifecycleException e) {
            log.warn("Couldn't stop tomcat.", (Throwable)e);
        }
    }

    public boolean isRunning() {
        return this.fRunning;
    }

    private void transferConnectorAttributes(final Connector connector, JSONObject config) {
        if (config == null) {
            return;
        }
        JsonVisitor.forEachElement((JSONObject)config, (JsonVisitor.ObjectVisitor)new JsonVisitor.ObjectVisitor<Object, JSONException>(){

            public boolean visit(String key, Object val) throws JSONException {
                connector.setProperty(key, String.valueOf(val));
                return true;
            }
        });
    }

    private static String scanKeystoreForPrivateKey(String keystoreFilename, String keystorePassword, String keystoreType) {
        try {
            log.info("Scanning {} for its first private key...", (Object)keystoreFilename);
            KeyStore ks = KeyStore.getInstance(keystoreType);
            ks.load(new FileInputStream(keystoreFilename), keystorePassword.toCharArray());
            log.info("Keystore {} loaded...", (Object)keystoreFilename);
            Enumeration<String> enumeration = ks.aliases();
            while (enumeration.hasMoreElements()) {
                String alias = enumeration.nextElement();
                if (!ks.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class)) continue;
                log.info("Found private key {}.", (Object)alias);
                return alias;
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException x) {
            log.warn("Exception inspecting keystore {} for alias: {}", (Object)keystoreFilename, (Object)x.getMessage());
        }
        return "";
    }
}

