/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.engine.library.processors;

import io.continual.builder.Builder;
import io.continual.services.processor.config.readers.ConfigLoadContext;
import io.continual.services.processor.engine.model.Message;
import io.continual.services.processor.engine.model.MessageProcessingContext;
import io.continual.services.processor.engine.model.Processor;
import io.continual.util.data.TypeConvertor;
import org.json.JSONException;
import org.json.JSONObject;

public class TypeChange
implements Processor {
    private final String fFromField;
    private final String fToField;
    private final Type fTargetType;

    public TypeChange(ConfigLoadContext sc, JSONObject config) throws Builder.BuildFailure {
        this(config);
    }

    public TypeChange(JSONObject config) throws Builder.BuildFailure {
        try {
            this.fFromField = config.getString("from");
            this.fTargetType = Type.valueOf(config.getString("toType").toUpperCase());
            this.fToField = config.optString("to", null);
        }
        catch (IllegalArgumentException e) {
            throw new Builder.BuildFailure((Throwable)e);
        }
        catch (JSONException e) {
            throw new Builder.BuildFailure((Throwable)e);
        }
    }

    @Override
    public void process(MessageProcessingContext context) {
        Message msg = context.getMessage();
        String fromVal = msg.getString(this.fFromField);
        String to = this.fToField == null ? this.fFromField : this.fToField;
        switch (this.fTargetType.ordinal()) {
            case 2: {
                msg.putValue(to, TypeConvertor.convertToBooleanBroad((String)fromVal));
                break;
            }
            case 1: {
                msg.putValue(to, TypeConvertor.convertToDouble((String)fromVal, (double)0.0));
                break;
            }
            default: {
                msg.putValue(to, fromVal);
            }
        }
    }

    public static enum Type {
        STRING,
        NUMBER,
        BOOLEAN;

    }
}

