/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.engine.library.processors;

import io.continual.builder.Builder;
import io.continual.services.processor.config.readers.ConfigLoadContext;
import io.continual.services.processor.engine.model.MessageProcessingContext;
import io.continual.services.processor.engine.model.Pipeline;
import io.continual.services.processor.engine.model.Processor;
import io.continual.services.processor.engine.model.Program;
import io.continual.util.data.json.JsonVisitor;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Call
implements Processor {
    private final List<String> fPipelines;

    public Call(String ... pipelines) {
        this.fPipelines = Arrays.asList(pipelines);
    }

    public Call(ConfigLoadContext sc, JSONObject config) throws Builder.BuildFailure {
        block4: {
            try {
                this.fPipelines = new LinkedList<String>();
                Object o = config.opt("to");
                if (o instanceof String) {
                    this.fPipelines.add(o.toString());
                    break block4;
                }
                if (o instanceof JSONArray) {
                    this.fPipelines.addAll(JsonVisitor.arrayToList((JSONArray)((JSONArray)o)));
                    break block4;
                }
                throw new Builder.BuildFailure("Call requires a 'to' value that's either a string or an array of strings.");
            }
            catch (JSONException e) {
                throw new Builder.BuildFailure((Throwable)e);
            }
        }
    }

    @Override
    public void process(MessageProcessingContext context) {
        Program p = context.getStreamProcessingContext().getProgram();
        for (String pn : this.fPipelines) {
            Pipeline pl = p.getPipeline(pn);
            if (pl == null) {
                context.stopProcessing("Pipeline " + pn + " is not in the program.");
                return;
            }
            pl.process(context);
        }
    }
}

