/*
 * Decompiled with CFR 0.152.
 */
package io.continual.jsonHttpClient.impl.ok;

import io.continual.jsonHttpClient.JsonOverHttpClient;
import io.continual.util.data.json.CommentedJsonTokener;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import okhttp3.MediaType;
import okhttp3.Response;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

class OkResponse
implements JsonOverHttpClient.HttpResponse {
    private final int fStatus;
    private final Response fResponse;

    public OkResponse(int status, Response resp) {
        this.fStatus = status;
        this.fResponse = resp;
    }

    @Override
    public void close() {
        if (this.fResponse != null) {
            this.fResponse.close();
        }
    }

    @Override
    public int getCode() {
        return this.fStatus;
    }

    @Override
    public String getMessage() {
        return this.fResponse.message();
    }

    @Override
    public JSONObject getBody() throws JsonOverHttpClient.BodyFormatException {
        return this.getBody(new JsonOverHttpClient.BodyFactory<JSONObject>(){

            @Override
            public JSONObject getBody(long length, String contentType, InputStream byteStream) {
                if (length == 0L) {
                    return new JSONObject();
                }
                try {
                    return new JSONObject((JSONTokener)new CommentedJsonTokener(byteStream));
                }
                catch (JSONException e) {
                    return new JSONObject().put("error", (Object)"couldn't read body from server").put("message", (Object)e.getMessage());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getBody(JsonOverHttpClient.BodyFactory<T> bf) throws JsonOverHttpClient.BodyFormatException {
        if (this.fResponse == null) {
            return null;
        }
        try {
            long length = this.fResponse.body().contentLength();
            MediaType mimeType = this.fResponse.body().contentType();
            String contentEncoding = this.fResponse.header("Content-Encoding");
            InputStream stream = this.fResponse.body().byteStream();
            if (contentEncoding != null && contentEncoding.equalsIgnoreCase("gzip")) {
                try {
                    stream = new GZIPInputStream(stream);
                }
                catch (IOException e) {
                    throw new JsonOverHttpClient.BodyFormatException(e);
                }
            }
            T t = bf.getBody(length, mimeType.toString(), stream);
            return t;
        }
        finally {
            this.fResponse.close();
        }
    }

    @Override
    public boolean isSuccess() {
        int code = this.getCode();
        return code >= 200 && code < 300;
    }
}

