/*
 * Decompiled with CFR 0.152.
 */
package io.continual.shaded.com.rabbitmq.tools.jsonrpc;

import io.continual.shaded.com.rabbitmq.tools.json.JSONUtil;
import java.util.Collection;
import java.util.Map;

public class ParameterDescription {
    private String name;
    private String type;

    public ParameterDescription() {
    }

    public ParameterDescription(Map<String, Object> pm) {
        JSONUtil.tryFill(this, pm);
    }

    public ParameterDescription(int index, Class<?> c) {
        this.name = "param" + index;
        this.type = ParameterDescription.lookup(c);
    }

    public static String lookup(Class<?> c) {
        if (c == Void.class) {
            return "nil";
        }
        if (c == Boolean.class) {
            return "bit";
        }
        if (c == Integer.class) {
            return "num";
        }
        if (c == Double.class) {
            return "num";
        }
        if (c == String.class) {
            return "str";
        }
        if (c.isArray()) {
            return "arr";
        }
        if (Map.class.isAssignableFrom(c)) {
            return "obj";
        }
        if (Collection.class.isAssignableFrom(c)) {
            return "arr";
        }
        return "any";
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }
}

