/*
 * Decompiled with CFR 0.152.
 */
package io.continual.templating.impl.catalogs.resource;

import io.continual.services.ServiceContainer;
import io.continual.services.SimpleService;
import io.continual.templating.ContinualTemplateCatalog;
import io.continual.templating.ContinualTemplateSource;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContinualTemplateResourceCatalog
extends SimpleService
implements ContinualTemplateCatalog {
    public static final String kSetting_BasePkg = "resourceBasePkg";
    public static final String kDefault_BasePkg = "";
    private final String fBasePkg;
    private static final Logger log = LoggerFactory.getLogger(ContinualTemplateResourceCatalog.class);

    public ContinualTemplateResourceCatalog(ServiceContainer sc, JSONObject config) {
        this.fBasePkg = sc.getExprEval().evaluateText(config.optString(kSetting_BasePkg, kDefault_BasePkg));
    }

    @Override
    public ContinualTemplateSource getTemplate(String ... names) throws ContinualTemplateSource.TemplateNotFoundException {
        ContinualTemplateSource[] srcs = new ContinualTemplateSource[names.length];
        for (int i = 0; i < names.length; ++i) {
            String res = names[i];
            if (this.fBasePkg.length() > 0) {
                res = this.fBasePkg + "/" + names[i];
            }
            srcs[i] = ContinualTemplateSource.fromResource(res, names[i]);
            log.debug("src[{}]={} from {}", new Object[]{i, res, names[i]});
        }
        return ContinualTemplateSource.combinedStreams(srcs);
    }
}

