/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.nv.impl;

import io.continual.util.data.TypeConvertor;
import io.continual.util.nv.NvReadable;
import io.continual.util.nv.NvWriteable;
import io.continual.util.nv.impl.nvBaseReadable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

public class nvCopyOnWriteTable
extends nvBaseReadable
implements NvWriteable {
    private data fData;

    public nvCopyOnWriteTable() {
        this.fData = new data();
        this.fData.attach();
    }

    public nvCopyOnWriteTable(nvCopyOnWriteTable that) {
        this.fData = that.fData;
        this.fData.attach();
    }

    public nvCopyOnWriteTable(Map<String, String> values) {
        this();
        this.fData.putAll(values);
    }

    @Override
    public synchronized boolean hasValueFor(String key) {
        return this.fData.containsKey(key);
    }

    @Override
    public synchronized String getString(String key) throws NvReadable.MissingReqdSettingException {
        return this.fData.get(key);
    }

    @Override
    public String[] getStrings(String key) throws NvReadable.MissingReqdSettingException {
        String fullset = this.getString(key);
        return fullset.split(",", -1);
    }

    @Override
    public synchronized Map<String, String> getCopyAsMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.putAll(this.fData.getSharedMap());
        return result;
    }

    @Override
    public synchronized int size() {
        return this.fData.size();
    }

    @Override
    public synchronized Collection<String> getAllKeys() {
        return this.fData.getAllKeys();
    }

    @Override
    public synchronized void copyInto(NvWriteable writeable) {
        this.fData.copyInto(writeable);
    }

    @Override
    public synchronized void copyInto(Map<String, String> that) {
        this.fData.copyInto(that);
    }

    synchronized data getDataReference() {
        return this.fData;
    }

    @Override
    public synchronized void clear() {
        this.fData = this.fData.clear();
    }

    @Override
    public synchronized void set(String key, String value) {
        if (value != null) {
            this.fData = this.fData.put(key, value);
        }
    }

    @Override
    public synchronized void unset(String key) {
        this.fData = this.fData.remove(key);
    }

    @Override
    public synchronized void set(Map<String, String> map) {
        this.fData = this.fData.putAll(map);
    }

    @Override
    public void set(String key, int value) {
        this.set(key, "" + value);
    }

    @Override
    public void set(String key, long value) {
        this.set(key, "" + value);
    }

    @Override
    public void set(String key, double value) {
        this.set(key, "" + value);
    }

    @Override
    public void set(String key, boolean value) {
        this.set(key, "" + value);
    }

    @Override
    public void set(String key, char value) {
        this.set(key, "" + value);
    }

    @Override
    public void set(String key, byte[] value) {
        this.set(key, value, 0, value.length);
    }

    @Override
    public void set(String key, byte[] value, int offset, int length) {
        this.set(key, TypeConvertor.bytesToHex(value, offset, length));
    }

    @Override
    public void set(String key, String[] values) {
        StringBuffer sb = new StringBuffer();
        boolean one = false;
        for (String value : values) {
            if (one) {
                sb.append(",");
            }
            sb.append(value);
            one = true;
        }
        this.set(key, sb.toString());
    }

    class data {
        private int fRefs = 0;
        private Hashtable<String, String> fData = new Hashtable();
        private long fWeight = 0L;

        public synchronized String get(String key) {
            return this.fData.get(key);
        }

        public synchronized data put(String key, String value) {
            data d = this.prepForWrite();
            d.fData.put(key, value);
            d.fWeight += this.calcWeight(key, value);
            return d;
        }

        public synchronized void attach() {
            ++this.fRefs;
        }

        public synchronized void detach() {
            --this.fRefs;
        }

        public synchronized Set<Map.Entry<String, String>> entrySet() {
            return this.fData.entrySet();
        }

        public synchronized int size() {
            return this.fData.size();
        }

        public synchronized Collection<String> getAllKeys() {
            return this.fData.keySet();
        }

        public synchronized data clear() {
            data d = this.prepForWrite();
            d.fData.clear();
            d.fWeight = 0L;
            return d;
        }

        public synchronized data remove(String key) {
            data d = this.prepForWrite();
            String val = d.fData.get(key);
            d.fData.remove(key);
            d.fWeight -= this.calcWeight(key, val);
            return d;
        }

        public synchronized data putAll(Map<String, String> map) {
            data d = this.prepForWrite();
            d.fData.putAll(map);
            for (Map.Entry<String, String> e : map.entrySet()) {
                d.fWeight += this.calcWeight(e.getKey(), e.getValue());
            }
            return d;
        }

        public synchronized boolean containsKey(String key) {
            return this.fData.containsKey(key);
        }

        public synchronized void copyInto(NvWriteable writeable) {
            writeable.set(this.fData);
        }

        public synchronized void copyInto(Map<String, String> that) {
            that.putAll(this.fData);
        }

        synchronized int getRefCount() {
            return this.fRefs;
        }

        synchronized Map<String, String> getSharedMap() {
            return this.fData;
        }

        synchronized double estimateWeight() {
            return (double)this.fWeight / (double)this.fRefs;
        }

        private data prepForWrite() {
            data result = this;
            if (this.fRefs > 1) {
                result = new data();
                result.attach();
                result.fData.putAll(this.fData);
                result.fWeight = this.fWeight;
                this.detach();
            }
            return result;
        }

        long calcWeight(String key, String val) {
            return key.length() + (val == null ? 0 : val.length());
        }
    }
}

