/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.data.csv;

import io.continual.util.data.StringUtils;
import io.continual.util.data.TypeConvertor;
import io.continual.util.data.csv.CsvStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public class CsvInspector {
    public static final int kTypeString = 1;
    public static final int kTypeNumeric = 2;
    public static final int kTypeDate = 4;
    private Vector<String> fLines = new Vector();
    private boolean fHeader = false;
    private char fQuoteChar = kStdQuotes[0];
    private char fDelimChar = kStdDelims[0];
    private int[] fTypes;
    private Vector<Vector<fieldInfo>> fFields;
    private static final char[] kStdDelims = new char[]{',', '|', '\t'};
    private static final char[] kStdQuotes = new char[]{'\"', '\''};
    private static final SimpleDateFormat[] kDateFormatters = new SimpleDateFormat[]{new SimpleDateFormat("MM/dd/yyyy"), new SimpleDateFormat("MM/dd/yy"), new SimpleDateFormat("MM-dd-yyyy"), new SimpleDateFormat("MM-dd-yy"), new SimpleDateFormat("yyyy-MM-dd"), new SimpleDateFormat("yy-MM-dd")};

    public void setHints(boolean header, char dc, char qc) {
        this.fHeader = header;
        this.fQuoteChar = qc;
        this.fDelimChar = dc;
    }

    public void reevaluate() {
        this.parseLines();
        this.inspectTypes();
    }

    public boolean readStreamForSample(InputStream is) {
        LinkedList<String> list = new LinkedList<String>();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        for (int i = 0; i < 10; ++i) {
            try {
                String line = br.readLine();
                if (line == null) continue;
                list.add(line);
                continue;
            }
            catch (IOException e) {
                break;
            }
        }
        return this.inputSample(list);
    }

    public boolean inputSample(String[] lines) {
        LinkedList<String> list = new LinkedList<String>();
        for (String line : lines) {
            list.add(line);
        }
        return this.inputSample(list);
    }

    public boolean inputSample(List<String> lines) {
        boolean decent = false;
        if (lines.size() >= 3) {
            this.fLines = new Vector();
            Iterator<String> it = lines.iterator();
            for (int i = 0; i < 5 && it.hasNext(); ++i) {
                this.fLines.add(it.next());
            }
            decent = this.detectSpecialChars() && this.detectHeader();
        }
        return decent;
    }

    public boolean hasHeaderLine() {
        return this.fHeader;
    }

    public char getQuoteChar() {
        return this.fQuoteChar;
    }

    public char getDelimiterChar() {
        return this.fDelimChar;
    }

    public int getFieldCount() {
        return this.fTypes.length;
    }

    public int getRowCount() {
        return this.fLines.size();
    }

    public int getTypePossibilities(int field) {
        return this.fTypes[field];
    }

    public String getLine(int i) {
        return this.fLines.elementAt(i);
    }

    public Vector<fieldInfo> getLineInfo(int i) {
        return this.fFields.elementAt(i);
    }

    private boolean detectSpecialChars() {
        double best = 0.0;
        for (char d : kStdDelims) {
            for (char q : kStdQuotes) {
                double trial = this.tryParse(d, q);
                if (!(trial > best)) continue;
                this.fQuoteChar = q;
                this.fDelimChar = d;
                best = trial;
            }
        }
        return best > 0.0;
    }

    private double tryParse(char d, char q) {
        int total = 0;
        int lines = 0;
        for (String line : this.fLines) {
            if (line.length() == 0) continue;
            List<StringUtils.fieldInfo> values = StringUtils.split(line, q, d);
            total += values.size();
            ++lines;
        }
        return (double)total / (double)lines;
    }

    private int detectType(String value) {
        int result = 1;
        try {
            TypeConvertor.convertToDouble(value);
            result |= 2;
        }
        catch (TypeConvertor.conversionError conversionError2) {
            // empty catch block
        }
        for (SimpleDateFormat df : kDateFormatters) {
            try {
                df.parse(value);
                result |= 4;
                break;
            }
            catch (ParseException parseException) {
            }
        }
        return result;
    }

    private void parseLines() {
        this.fFields = new Vector();
        int lineNo = -1;
        for (String line : this.fLines) {
            Vector<fieldInfo> fieldSet = new Vector<fieldInfo>();
            this.fFields.insertElementAt(fieldSet, ++lineNo);
            List<String> values = CsvStream.parseHeaderLine(line, this.fQuoteChar, this.fDelimChar);
            int colNo = -1;
            for (String value : values) {
                fieldInfo fi = new fieldInfo();
                fi.fValue = value;
                fi.fTypeMask = this.detectType(value);
                fieldSet.insertElementAt(fi, ++colNo);
            }
        }
    }

    private void inspectTypes() {
        int i;
        int count = this.fFields.elementAt(1).size();
        this.fTypes = new int[count];
        for (i = 0; i < count; ++i) {
            this.fTypes[i] = 7;
        }
        for (i = 1; i < this.fFields.size(); ++i) {
            Vector<fieldInfo> row = this.fFields.elementAt(i);
            for (int j = 0; j < count; ++j) {
                int anded;
                if (row.size() <= j) continue;
                fieldInfo field = row.elementAt(j);
                int fieldType = field.fTypeMask;
                this.fTypes[j] = anded = fieldType & this.fTypes[j];
            }
        }
    }

    private boolean detectHeader() {
        this.parseLines();
        this.inspectTypes();
        boolean same = true;
        Vector<fieldInfo> row = this.fFields.elementAt(0);
        for (int j = 0; j < this.fTypes.length; ++j) {
            if (row.size() <= j) continue;
            fieldInfo field = row.elementAt(j);
            int fieldType = field.fTypeMask;
            int colDataType = this.fTypes[j];
            int mask = colDataType & fieldType;
            boolean bl = same = same && mask == colDataType;
            if (!same) break;
        }
        this.fHeader = !same;
        return true;
    }

    public static class fieldInfo {
        public String fValue;
        public int fTypeMask;

        public String value() {
            return this.fValue;
        }
    }
}

