/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.data;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamTools {
    protected static final int kBufferLength = 4096;

    private StreamTools() {
    }

    public static byte[] readBytes(InputStream is) throws IOException {
        return StreamTools.readBytes(is, 4096);
    }

    public static byte[] readBytes(InputStream is, int bufferSize) throws IOException {
        return StreamTools.readBytes(is, bufferSize, -1);
    }

    public static byte[] readBytes(InputStream is, int bufferSize, int limit) throws IOException {
        int counter = 0;
        int atMost = limit < 0 ? Integer.MAX_VALUE : Math.min(limit, Integer.MAX_VALUE);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (is != null) {
            byte[] b = new byte[bufferSize];
            int len = 0;
            do {
                if (-1 == (len = is.read(b))) continue;
                int readNow = Math.min(len, atMost - counter);
                baos.write(b, 0, readNow);
                counter += readNow;
            } while (len != -1 && counter < atMost);
            is.close();
        }
        return baos.toByteArray();
    }

    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        new StreamCopier().from(in).to(out).copy();
    }

    public static void copyStream(InputStream in, OutputStream out, int bufferSize) throws IOException {
        new StreamCopier().from(in).to(out).withBufferSize(bufferSize).copy();
    }

    public static void copyStream(InputStream in, OutputStream out, int bufferSize, boolean closeOutputStream) throws IOException {
        new StreamCopier().from(in).to(out).withBufferSize(bufferSize).closeStream(closeOutputStream).copy();
    }

    public static class StreamCopier {
        private InputStream fFrom;
        private OutputStream fTo;
        private int fBufferSize = 4096;
        private boolean fCloseStream = true;

        public StreamCopier from(InputStream is) {
            this.fFrom = is;
            return this;
        }

        public StreamCopier to(OutputStream os) {
            this.fTo = os;
            return this;
        }

        public StreamCopier withBufferSize(int bufSize) {
            this.fBufferSize = bufSize;
            return this;
        }

        public StreamCopier closeStream() {
            return this.closeStream(true);
        }

        public StreamCopier leaveStreamOpen() {
            return this.closeStream(false);
        }

        public StreamCopier closeStream(boolean cs) {
            this.fCloseStream = cs;
            return this;
        }

        public void copy() throws IOException {
            int len;
            byte[] buffer = new byte[this.fBufferSize];
            while ((len = this.fFrom.read(buffer)) != -1) {
                this.fTo.write(buffer, 0, len);
            }
            if (this.fCloseStream) {
                this.fTo.close();
            }
        }
    }
}

